/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type for public key information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicKeySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicKeySummary.Builder, PublicKeySummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKeySummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKeySummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PublicKeySummary::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<String> ENCODED_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKeySummary::encodedKey))
            .setter(setter(Builder::encodedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedKey")
                    .unmarshallLocationName("EncodedKey").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKeySummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CREATED_TIME_FIELD, ENCODED_KEY_FIELD, COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final Instant createdTime;

    private final String encodedKey;

    private final String comment;

    private PublicKeySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.encodedKey = builder.encodedKey;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * ID for public key information summary.
     * </p>
     * 
     * @return ID for public key information summary.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * Name for public key information summary.
     * </p>
     * 
     * @return Name for public key information summary.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Creation time for public key information summary.
     * </p>
     * 
     * @return Creation time for public key information summary.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Encoded key for public key information summary.
     * </p>
     * 
     * @return Encoded key for public key information summary.
     */
    public String encodedKey() {
        return encodedKey;
    }

    /**
     * <p>
     * Comment for public key information summary.
     * </p>
     * 
     * @return Comment for public key information summary.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(encodedKey());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKeySummary)) {
            return false;
        }
        PublicKeySummary other = (PublicKeySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(encodedKey(), other.encodedKey())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PublicKeySummary").add("Id", id()).add("Name", name()).add("CreatedTime", createdTime())
                .add("EncodedKey", encodedKey()).add("Comment", comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "EncodedKey":
            return Optional.ofNullable(clazz.cast(encodedKey()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKeySummary, T> g) {
        return obj -> g.apply((PublicKeySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicKeySummary> {
        /**
         * <p>
         * ID for public key information summary.
         * </p>
         * 
         * @param id
         *        ID for public key information summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Name for public key information summary.
         * </p>
         * 
         * @param name
         *        Name for public key information summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Creation time for public key information summary.
         * </p>
         * 
         * @param createdTime
         *        Creation time for public key information summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Encoded key for public key information summary.
         * </p>
         * 
         * @param encodedKey
         *        Encoded key for public key information summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedKey(String encodedKey);

        /**
         * <p>
         * Comment for public key information summary.
         * </p>
         * 
         * @param comment
         *        Comment for public key information summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private Instant createdTime;

        private String encodedKey;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKeySummary model) {
            id(model.id);
            name(model.name);
            createdTime(model.createdTime);
            encodedKey(model.encodedKey);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getEncodedKey() {
            return encodedKey;
        }

        @Override
        public final Builder encodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        public final void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public PublicKeySummary build() {
            return new PublicKeySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
