/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom origin or an Amazon S3 bucket configured as a website endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomOriginConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomOriginConfig.Builder, CustomOriginConfig> {
    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CustomOriginConfig::httpPort))
            .setter(setter(Builder::httpPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPPort")
                    .unmarshallLocationName("HTTPPort").build()).build();

    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CustomOriginConfig::httpsPort))
            .setter(setter(Builder::httpsPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPSPort")
                    .unmarshallLocationName("HTTPSPort").build()).build();

    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CustomOriginConfig::originProtocolPolicyAsString))
            .setter(setter(Builder::originProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy")
                    .unmarshallLocationName("OriginProtocolPolicy").build()).build();

    private static final SdkField<OriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField
            .<OriginSslProtocols> builder(MarshallingType.SDK_POJO)
            .getter(getter(CustomOriginConfig::originSslProtocols))
            .setter(setter(Builder::originSslProtocols))
            .constructor(OriginSslProtocols::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols")
                    .unmarshallLocationName("OriginSslProtocols").build()).build();

    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CustomOriginConfig::originReadTimeout))
            .setter(setter(Builder::originReadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout")
                    .unmarshallLocationName("OriginReadTimeout").build()).build();

    private static final SdkField<Integer> ORIGIN_KEEPALIVE_TIMEOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CustomOriginConfig::originKeepaliveTimeout))
            .setter(setter(Builder::originKeepaliveTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginKeepaliveTimeout")
                    .unmarshallLocationName("OriginKeepaliveTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_PORT_FIELD,
            HTTPS_PORT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_SSL_PROTOCOLS_FIELD, ORIGIN_READ_TIMEOUT_FIELD,
            ORIGIN_KEEPALIVE_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer httpPort;

    private final Integer httpsPort;

    private final String originProtocolPolicy;

    private final OriginSslProtocols originSslProtocols;

    private final Integer originReadTimeout;

    private final Integer originKeepaliveTimeout;

    private CustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
        this.originReadTimeout = builder.originReadTimeout;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
    }

    /**
     * <p>
     * The HTTP port the custom origin listens on.
     * </p>
     * 
     * @return The HTTP port the custom origin listens on.
     */
    public Integer httpPort() {
        return httpPort;
    }

    /**
     * <p>
     * The HTTPS port the custom origin listens on.
     * </p>
     * 
     * @return The HTTPS port the custom origin listens on.
     */
    public Integer httpsPort() {
        return httpsPort;
    }

    /**
     * <p>
     * The origin protocol policy to apply to your origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyAsString}.
     * </p>
     * 
     * @return The origin protocol policy to apply to your origin.
     * @see OriginProtocolPolicy
     */
    public OriginProtocolPolicy originProtocolPolicy() {
        return OriginProtocolPolicy.fromValue(originProtocolPolicy);
    }

    /**
     * <p>
     * The origin protocol policy to apply to your origin.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyAsString}.
     * </p>
     * 
     * @return The origin protocol policy to apply to your origin.
     * @see OriginProtocolPolicy
     */
    public String originProtocolPolicyAsString() {
        return originProtocolPolicy;
    }

    /**
     * <p>
     * The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
     * </p>
     * 
     * @return The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
     */
    public OriginSslProtocols originSslProtocols() {
        return originSslProtocols;
    }

    /**
     * <p>
     * You can create a custom origin read timeout. All timeout units are in seconds. The default origin read timeout is
     * 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout length is
     * 4 seconds; the maximum is 60 seconds.
     * </p>
     * <p>
     * If you need to increase the maximum time limit, contact the <a
     * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     * </p>
     * 
     * @return You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
     *         timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
     *         timeout length is 4 seconds; the maximum is 60 seconds.</p>
     *         <p>
     *         If you need to increase the maximum time limit, contact the <a
     *         href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     */
    public Integer originReadTimeout() {
        return originReadTimeout;
    }

    /**
     * <p>
     * You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive timeout is 5
     * seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout length is 1
     * second; the maximum is 60 seconds.
     * </p>
     * <p>
     * If you need to increase the maximum time limit, contact the <a
     * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     * </p>
     * 
     * @return You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive
     *         timeout is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
     *         timeout length is 1 second; the maximum is 60 seconds.</p>
     *         <p>
     *         If you need to increase the maximum time limit, contact the <a
     *         href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
     */
    public Integer originKeepaliveTimeout() {
        return originKeepaliveTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(originProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originSslProtocols());
        hashCode = 31 * hashCode + Objects.hashCode(originReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(originKeepaliveTimeout());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOriginConfig)) {
            return false;
        }
        CustomOriginConfig other = (CustomOriginConfig) obj;
        return Objects.equals(httpPort(), other.httpPort()) && Objects.equals(httpsPort(), other.httpsPort())
                && Objects.equals(originProtocolPolicyAsString(), other.originProtocolPolicyAsString())
                && Objects.equals(originSslProtocols(), other.originSslProtocols())
                && Objects.equals(originReadTimeout(), other.originReadTimeout())
                && Objects.equals(originKeepaliveTimeout(), other.originKeepaliveTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CustomOriginConfig").add("HTTPPort", httpPort()).add("HTTPSPort", httpsPort())
                .add("OriginProtocolPolicy", originProtocolPolicyAsString()).add("OriginSslProtocols", originSslProtocols())
                .add("OriginReadTimeout", originReadTimeout()).add("OriginKeepaliveTimeout", originKeepaliveTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HTTPPort":
            return Optional.ofNullable(clazz.cast(httpPort()));
        case "HTTPSPort":
            return Optional.ofNullable(clazz.cast(httpsPort()));
        case "OriginProtocolPolicy":
            return Optional.ofNullable(clazz.cast(originProtocolPolicyAsString()));
        case "OriginSslProtocols":
            return Optional.ofNullable(clazz.cast(originSslProtocols()));
        case "OriginReadTimeout":
            return Optional.ofNullable(clazz.cast(originReadTimeout()));
        case "OriginKeepaliveTimeout":
            return Optional.ofNullable(clazz.cast(originKeepaliveTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomOriginConfig, T> g) {
        return obj -> g.apply((CustomOriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomOriginConfig> {
        /**
         * <p>
         * The HTTP port the custom origin listens on.
         * </p>
         * 
         * @param httpPort
         *        The HTTP port the custom origin listens on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPort(Integer httpPort);

        /**
         * <p>
         * The HTTPS port the custom origin listens on.
         * </p>
         * 
         * @param httpsPort
         *        The HTTPS port the custom origin listens on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsPort(Integer httpsPort);

        /**
         * <p>
         * The origin protocol policy to apply to your origin.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy to apply to your origin.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(String originProtocolPolicy);

        /**
         * <p>
         * The origin protocol policy to apply to your origin.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy to apply to your origin.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy);

        /**
         * <p>
         * The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
         * </p>
         * 
         * @param originSslProtocols
         *        The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originSslProtocols(OriginSslProtocols originSslProtocols);

        /**
         * <p>
         * The SSL/TLS protocols that you want CloudFront to use when communicating with your origin over HTTPS.
         * </p>
         * This is a convenience that creates an instance of the {@link OriginSslProtocols.Builder} avoiding the need to
         * create one manually via {@link OriginSslProtocols#builder()}.
         *
         * When the {@link Consumer} completes, {@link OriginSslProtocols.Builder#build()} is called immediately and its
         * result is passed to {@link #originSslProtocols(OriginSslProtocols)}.
         * 
         * @param originSslProtocols
         *        a consumer that will call methods on {@link OriginSslProtocols.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originSslProtocols(OriginSslProtocols)
         */
        default Builder originSslProtocols(Consumer<OriginSslProtocols.Builder> originSslProtocols) {
            return originSslProtocols(OriginSslProtocols.builder().applyMutation(originSslProtocols).build());
        }

        /**
         * <p>
         * You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
         * timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum
         * timeout length is 4 seconds; the maximum is 60 seconds.
         * </p>
         * <p>
         * If you need to increase the maximum time limit, contact the <a
         * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * </p>
         * 
         * @param originReadTimeout
         *        You can create a custom origin read timeout. All timeout units are in seconds. The default origin read
         *        timeout is 30 seconds, but you can configure custom timeout lengths using the CloudFront API. The
         *        minimum timeout length is 4 seconds; the maximum is 60 seconds.</p>
         *        <p>
         *        If you need to increase the maximum time limit, contact the <a
         *        href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originReadTimeout(Integer originReadTimeout);

        /**
         * <p>
         * You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive timeout
         * is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The minimum timeout
         * length is 1 second; the maximum is 60 seconds.
         * </p>
         * <p>
         * If you need to increase the maximum time limit, contact the <a
         * href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * </p>
         * 
         * @param originKeepaliveTimeout
         *        You can create a custom keep-alive timeout. All timeout units are in seconds. The default keep-alive
         *        timeout is 5 seconds, but you can configure custom timeout lengths using the CloudFront API. The
         *        minimum timeout length is 1 second; the maximum is 60 seconds.</p>
         *        <p>
         *        If you need to increase the maximum time limit, contact the <a
         *        href="https://console.aws.amazon.com/support/home#/">AWS Support Center</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originKeepaliveTimeout(Integer originKeepaliveTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer httpPort;

        private Integer httpsPort;

        private String originProtocolPolicy;

        private OriginSslProtocols originSslProtocols;

        private Integer originReadTimeout;

        private Integer originKeepaliveTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOriginConfig model) {
            httpPort(model.httpPort);
            httpsPort(model.httpsPort);
            originProtocolPolicy(model.originProtocolPolicy);
            originSslProtocols(model.originSslProtocols);
            originReadTimeout(model.originReadTimeout);
            originKeepaliveTimeout(model.originKeepaliveTimeout);
        }

        public final Integer getHttpPort() {
            return httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        public final Integer getHttpsPort() {
            return httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        public final String getOriginProtocolPolicyAsString() {
            return originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy == null ? null : originProtocolPolicy.toString());
            return this;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        public final OriginSslProtocols.Builder getOriginSslProtocols() {
            return originSslProtocols != null ? originSslProtocols.toBuilder() : null;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public final void setOriginSslProtocols(OriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        public final Integer getOriginReadTimeout() {
            return originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        @Override
        public CustomOriginConfig build() {
            return new CustomOriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
