/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of public keys you've added to CloudFront to use with features like field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicKeyList implements SdkPojo, Serializable, ToCopyableBuilder<PublicKeyList.Builder, PublicKeyList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicKeyList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicKeyList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicKeyList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<PublicKeySummary>> ITEMS_FIELD = SdkField
            .<List<PublicKeySummary>> builder(MarshallingType.LIST)
            .getter(getter(PublicKeyList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("PublicKeySummary")
                            .memberFieldInfo(
                                    SdkField.<PublicKeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicKeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("PublicKeySummary").unmarshallLocationName("PublicKeySummary")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextMarker;

    private final Integer maxItems;

    private final Integer quantity;

    private final List<PublicKeySummary> items;

    private PublicKeyList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * If there are more elements to be listed, this element is present and contains the value that you can use for the
     * <code>Marker</code> request parameter to continue listing your public keys where you left off.
     * </p>
     * 
     * @return If there are more elements to be listed, this element is present and contains the value that you can use
     *         for the <code>Marker</code> request parameter to continue listing your public keys where you left off.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of public keys you want in the response body.
     * </p>
     * 
     * @return The maximum number of public keys you want in the response body.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The number of public keys you added to CloudFront to use with features like field-level encryption.
     * </p>
     * 
     * @return The number of public keys you added to CloudFront to use with features like field-level encryption.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * An array of information about a public key you add to CloudFront to use with features like field-level
     * encryption.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of information about a public key you add to CloudFront to use with features like field-level
     *         encryption.
     */
    public List<PublicKeySummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKeyList)) {
            return false;
        }
        PublicKeyList other = (PublicKeyList) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PublicKeyList").add("NextMarker", nextMarker()).add("MaxItems", maxItems())
                .add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKeyList, T> g) {
        return obj -> g.apply((PublicKeyList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicKeyList> {
        /**
         * <p>
         * If there are more elements to be listed, this element is present and contains the value that you can use for
         * the <code>Marker</code> request parameter to continue listing your public keys where you left off.
         * </p>
         * 
         * @param nextMarker
         *        If there are more elements to be listed, this element is present and contains the value that you can
         *        use for the <code>Marker</code> request parameter to continue listing your public keys where you left
         *        off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of public keys you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of public keys you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The number of public keys you added to CloudFront to use with features like field-level encryption.
         * </p>
         * 
         * @param quantity
         *        The number of public keys you added to CloudFront to use with features like field-level encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * An array of information about a public key you add to CloudFront to use with features like field-level
         * encryption.
         * </p>
         * 
         * @param items
         *        An array of information about a public key you add to CloudFront to use with features like field-level
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<PublicKeySummary> items);

        /**
         * <p>
         * An array of information about a public key you add to CloudFront to use with features like field-level
         * encryption.
         * </p>
         * 
         * @param items
         *        An array of information about a public key you add to CloudFront to use with features like field-level
         *        encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(PublicKeySummary... items);

        /**
         * <p>
         * An array of information about a public key you add to CloudFront to use with features like field-level
         * encryption.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PublicKeySummary>.Builder} avoiding the
         * need to create one manually via {@link List<PublicKeySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PublicKeySummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #items(List<PublicKeySummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<PublicKeySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<PublicKeySummary>)
         */
        Builder items(Consumer<PublicKeySummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String nextMarker;

        private Integer maxItems;

        private Integer quantity;

        private List<PublicKeySummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKeyList model) {
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<PublicKeySummary.Builder> getItems() {
            return items != null ? items.stream().map(PublicKeySummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<PublicKeySummary> items) {
            this.items = PublicKeySummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(PublicKeySummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<PublicKeySummary.Builder>... items) {
            items(Stream.of(items).map(c -> PublicKeySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<PublicKeySummary.BuilderImpl> items) {
            this.items = PublicKeySummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public PublicKeyList build() {
            return new PublicKeyList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
