/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDistributionsByCachePolicyIdRequest extends CloudFrontRequest implements
        ToCopyableBuilder<ListDistributionsByCachePolicyIdRequest.Builder, ListDistributionsByCachePolicyIdRequest> {
    private static final SdkField<String> MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Marker")
            .getter(getter(ListDistributionsByCachePolicyIdRequest::marker))
            .setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker")
                    .unmarshallLocationName("Marker").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListDistributionsByCachePolicyIdRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<String> CACHE_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CachePolicyId")
            .getter(getter(ListDistributionsByCachePolicyIdRequest::cachePolicyId))
            .setter(setter(Builder::cachePolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CachePolicyId")
                    .unmarshallLocationName("CachePolicyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, MAX_ITEMS_FIELD,
            CACHE_POLICY_ID_FIELD));

    private final String marker;

    private final String maxItems;

    private final String cachePolicyId;

    private ListDistributionsByCachePolicyIdRequest(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.cachePolicyId = builder.cachePolicyId;
    }

    /**
     * <p>
     * Use this field when paginating results to indicate where to begin in your list of distribution IDs. The response
     * includes distribution IDs in the list that occur after the marker. To get the next page of the list, set this
     * field's value to the value of <code>NextMarker</code> from the current page's response.
     * </p>
     * 
     * @return Use this field when paginating results to indicate where to begin in your list of distribution IDs. The
     *         response includes distribution IDs in the list that occur after the marker. To get the next page of the
     *         list, set this field's value to the value of <code>NextMarker</code> from the current page's response.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distribution IDs that you want in the response.
     * </p>
     * 
     * @return The maximum number of distribution IDs that you want in the response.
     */
    public final String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The ID of the cache policy whose associated distribution IDs you want to list.
     * </p>
     * 
     * @return The ID of the cache policy whose associated distribution IDs you want to list.
     */
    public final String cachePolicyId() {
        return cachePolicyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByCachePolicyIdRequest)) {
            return false;
        }
        ListDistributionsByCachePolicyIdRequest other = (ListDistributionsByCachePolicyIdRequest) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(cachePolicyId(), other.cachePolicyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDistributionsByCachePolicyIdRequest").add("Marker", marker()).add("MaxItems", maxItems())
                .add("CachePolicyId", cachePolicyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "CachePolicyId":
            return Optional.ofNullable(clazz.cast(cachePolicyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionsByCachePolicyIdRequest, T> g) {
        return obj -> g.apply((ListDistributionsByCachePolicyIdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDistributionsByCachePolicyIdRequest> {
        /**
         * <p>
         * Use this field when paginating results to indicate where to begin in your list of distribution IDs. The
         * response includes distribution IDs in the list that occur after the marker. To get the next page of the list,
         * set this field's value to the value of <code>NextMarker</code> from the current page's response.
         * </p>
         * 
         * @param marker
         *        Use this field when paginating results to indicate where to begin in your list of distribution IDs.
         *        The response includes distribution IDs in the list that occur after the marker. To get the next page
         *        of the list, set this field's value to the value of <code>NextMarker</code> from the current page's
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distribution IDs that you want in the response.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distribution IDs that you want in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The ID of the cache policy whose associated distribution IDs you want to list.
         * </p>
         * 
         * @param cachePolicyId
         *        The ID of the cache policy whose associated distribution IDs you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyId(String cachePolicyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String cachePolicyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByCachePolicyIdRequest model) {
            super(model);
            marker(model.marker);
            maxItems(model.maxItems);
            cachePolicyId(model.cachePolicyId);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getCachePolicyId() {
            return cachePolicyId;
        }

        public final void setCachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
        }

        @Override
        public final Builder cachePolicyId(String cachePolicyId) {
            this.cachePolicyId = cachePolicyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDistributionsByCachePolicyIdRequest build() {
            return new ListDistributionsByCachePolicyIdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
