/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex data type of profiles for the field-level encryption.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionProfileConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionProfileConfig.Builder, FieldLevelEncryptionProfileConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(FieldLevelEncryptionProfileConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(FieldLevelEncryptionProfileConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(FieldLevelEncryptionProfileConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<EncryptionEntities> ENCRYPTION_ENTITIES_FIELD = SdkField
            .<EncryptionEntities> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionEntities")
            .getter(getter(FieldLevelEncryptionProfileConfig::encryptionEntities))
            .setter(setter(Builder::encryptionEntities))
            .constructor(EncryptionEntities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEntities")
                    .unmarshallLocationName("EncryptionEntities").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CALLER_REFERENCE_FIELD, COMMENT_FIELD, ENCRYPTION_ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String callerReference;

    private final String comment;

    private final EncryptionEntities encryptionEntities;

    private FieldLevelEncryptionProfileConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.comment = builder.comment;
        this.encryptionEntities = builder.encryptionEntities;
    }

    /**
     * <p>
     * Profile name for the field-level encryption profile.
     * </p>
     * 
     * @return Profile name for the field-level encryption profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique number that ensures that the request can't be replayed.
     * </p>
     * 
     * @return A unique number that ensures that the request can't be replayed.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * An optional comment for the field-level encryption profile. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return An optional comment for the field-level encryption profile. The comment cannot be longer than 128
     *         characters.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex data type of encryption entities for the field-level encryption profile that include the public key ID,
     * provider, and field patterns for specifying which fields to encrypt with this key.
     * </p>
     * 
     * @return A complex data type of encryption entities for the field-level encryption profile that include the public
     *         key ID, provider, and field patterns for specifying which fields to encrypt with this key.
     */
    public final EncryptionEntities encryptionEntities() {
        return encryptionEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionEntities());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionProfileConfig)) {
            return false;
        }
        FieldLevelEncryptionProfileConfig other = (FieldLevelEncryptionProfileConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(comment(), other.comment()) && Objects.equals(encryptionEntities(), other.encryptionEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryptionProfileConfig").add("Name", name())
                .add("CallerReference", callerReference()).add("Comment", comment())
                .add("EncryptionEntities", encryptionEntities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "EncryptionEntities":
            return Optional.ofNullable(clazz.cast(encryptionEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionProfileConfig, T> g) {
        return obj -> g.apply((FieldLevelEncryptionProfileConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionProfileConfig> {
        /**
         * <p>
         * Profile name for the field-level encryption profile.
         * </p>
         * 
         * @param name
         *        Profile name for the field-level encryption profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique number that ensures that the request can't be replayed.
         * </p>
         * 
         * @param callerReference
         *        A unique number that ensures that the request can't be replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * An optional comment for the field-level encryption profile. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        An optional comment for the field-level encryption profile. The comment cannot be longer than 128
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex data type of encryption entities for the field-level encryption profile that include the public key
         * ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * </p>
         * 
         * @param encryptionEntities
         *        A complex data type of encryption entities for the field-level encryption profile that include the
         *        public key ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionEntities(EncryptionEntities encryptionEntities);

        /**
         * <p>
         * A complex data type of encryption entities for the field-level encryption profile that include the public key
         * ID, provider, and field patterns for specifying which fields to encrypt with this key.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionEntities.Builder} avoiding the
         * need to create one manually via {@link EncryptionEntities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionEntities.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionEntities(EncryptionEntities)}.
         * 
         * @param encryptionEntities
         *        a consumer that will call methods on {@link EncryptionEntities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionEntities(EncryptionEntities)
         */
        default Builder encryptionEntities(Consumer<EncryptionEntities.Builder> encryptionEntities) {
            return encryptionEntities(EncryptionEntities.builder().applyMutation(encryptionEntities).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String callerReference;

        private String comment;

        private EncryptionEntities encryptionEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionProfileConfig model) {
            name(model.name);
            callerReference(model.callerReference);
            comment(model.comment);
            encryptionEntities(model.encryptionEntities);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final EncryptionEntities.Builder getEncryptionEntities() {
            return encryptionEntities != null ? encryptionEntities.toBuilder() : null;
        }

        public final void setEncryptionEntities(EncryptionEntities.BuilderImpl encryptionEntities) {
            this.encryptionEntities = encryptionEntities != null ? encryptionEntities.build() : null;
        }

        @Override
        public final Builder encryptionEntities(EncryptionEntities encryptionEntities) {
            this.encryptionEntities = encryptionEntities;
            return this;
        }

        @Override
        public FieldLevelEncryptionProfileConfig build() {
            return new FieldLevelEncryptionProfileConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
