/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of field-level encrpytion configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldLevelEncryptionList implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldLevelEncryptionList.Builder, FieldLevelEncryptionList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(FieldLevelEncryptionList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(FieldLevelEncryptionList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(FieldLevelEncryptionList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<FieldLevelEncryptionSummary>> ITEMS_FIELD = SdkField
            .<List<FieldLevelEncryptionSummary>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(FieldLevelEncryptionList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("FieldLevelEncryptionSummary")
                            .memberFieldInfo(
                                    SdkField.<FieldLevelEncryptionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldLevelEncryptionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("FieldLevelEncryptionSummary")
                                                    .unmarshallLocationName("FieldLevelEncryptionSummary").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextMarker;

    private final Integer maxItems;

    private final Integer quantity;

    private final List<FieldLevelEncryptionSummary> items;

    private FieldLevelEncryptionList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * If there are more elements to be listed, this element is present and contains the value that you can use for the
     * <code>Marker</code> request parameter to continue listing your configurations where you left off.
     * </p>
     * 
     * @return If there are more elements to be listed, this element is present and contains the value that you can use
     *         for the <code>Marker</code> request parameter to continue listing your configurations where you left off.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of elements you want in the response body.
     * </p>
     * 
     * @return The maximum number of elements you want in the response body.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The number of field-level encryption items.
     * </p>
     * 
     * @return The number of field-level encryption items.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of field-level encryption items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return An array of field-level encryption items.
     */
    public final List<FieldLevelEncryptionSummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldLevelEncryptionList)) {
            return false;
        }
        FieldLevelEncryptionList other = (FieldLevelEncryptionList) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldLevelEncryptionList").add("NextMarker", nextMarker()).add("MaxItems", maxItems())
                .add("Quantity", quantity()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldLevelEncryptionList, T> g) {
        return obj -> g.apply((FieldLevelEncryptionList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldLevelEncryptionList> {
        /**
         * <p>
         * If there are more elements to be listed, this element is present and contains the value that you can use for
         * the <code>Marker</code> request parameter to continue listing your configurations where you left off.
         * </p>
         * 
         * @param nextMarker
         *        If there are more elements to be listed, this element is present and contains the value that you can
         *        use for the <code>Marker</code> request parameter to continue listing your configurations where you
         *        left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of elements you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of elements you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The number of field-level encryption items.
         * </p>
         * 
         * @param quantity
         *        The number of field-level encryption items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * An array of field-level encryption items.
         * </p>
         * 
         * @param items
         *        An array of field-level encryption items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<FieldLevelEncryptionSummary> items);

        /**
         * <p>
         * An array of field-level encryption items.
         * </p>
         * 
         * @param items
         *        An array of field-level encryption items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(FieldLevelEncryptionSummary... items);

        /**
         * <p>
         * An array of field-level encryption items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #items(List<FieldLevelEncryptionSummary>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<FieldLevelEncryptionSummary>)
         */
        Builder items(Consumer<FieldLevelEncryptionSummary.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String nextMarker;

        private Integer maxItems;

        private Integer quantity;

        private List<FieldLevelEncryptionSummary> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldLevelEncryptionList model) {
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<FieldLevelEncryptionSummary.Builder> getItems() {
            List<FieldLevelEncryptionSummary.Builder> result = FieldLevelEncryptionSummaryListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<FieldLevelEncryptionSummary.BuilderImpl> items) {
            this.items = FieldLevelEncryptionSummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<FieldLevelEncryptionSummary> items) {
            this.items = FieldLevelEncryptionSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(FieldLevelEncryptionSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<FieldLevelEncryptionSummary.Builder>... items) {
            items(Stream.of(items).map(c -> FieldLevelEncryptionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FieldLevelEncryptionList build() {
            return new FieldLevelEncryptionList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
