/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this field.
 * </p>
 * <p>
 * If you want to include cookies in the cache key, use <code>CookiesConfig</code> in a cache policy. See
 * <code>CachePolicy</code>.
 * </p>
 * <p>
 * If you want to send cookies to the origin but not include them in the cache key, use <code>CookiesConfig</code> in an
 * origin request policy. See <code>OriginRequestPolicy</code>.
 * </p>
 * <p>
 * A complex type that specifies whether you want CloudFront to forward cookies to the origin and, if so, which ones.
 * For more information about forwarding cookies to the origin, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Cookies.html">Caching Content Based on
 * Cookies</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CookiePreference implements SdkPojo, Serializable,
        ToCopyableBuilder<CookiePreference.Builder, CookiePreference> {
    private static final SdkField<String> FORWARD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Forward")
            .getter(getter(CookiePreference::forwardAsString))
            .setter(setter(Builder::forward))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forward")
                    .unmarshallLocationName("Forward").build()).build();

    private static final SdkField<CookieNames> WHITELISTED_NAMES_FIELD = SdkField
            .<CookieNames> builder(MarshallingType.SDK_POJO)
            .memberName("WhitelistedNames")
            .getter(getter(CookiePreference::whitelistedNames))
            .setter(setter(Builder::whitelistedNames))
            .constructor(CookieNames::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhitelistedNames")
                    .unmarshallLocationName("WhitelistedNames").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORWARD_FIELD,
            WHITELISTED_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String forward;

    private final CookieNames whitelistedNames;

    private CookiePreference(BuilderImpl builder) {
        this.forward = builder.forward;
        this.whitelistedNames = builder.whitelistedNames;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
     * specified in the <code>WhitelistedNames</code> complex type.
     * </p>
     * <p>
     * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify
     * none for the <code>Forward</code> element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #forward} will
     * return {@link ItemSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #forwardAsString}.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send cookies to the origin but not include them in the cache key, use origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
     *         cookies specified in the <code>WhitelistedNames</code> complex type.
     *         </p>
     *         <p>
     *         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
     *         specify none for the <code>Forward</code> element.
     * @see ItemSelection
     */
    public final ItemSelection forward() {
        return ItemSelection.fromValue(forward);
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send cookies to the origin but not include them in the cache key, use origin request policy. For
     * more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
     * specified in the <code>WhitelistedNames</code> complex type.
     * </p>
     * <p>
     * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin, specify
     * none for the <code>Forward</code> element.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #forward} will
     * return {@link ItemSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #forwardAsString}.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send cookies to the origin but not include them in the cache key, use origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
     *         cookies specified in the <code>WhitelistedNames</code> complex type.
     *         </p>
     *         <p>
     *         Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
     *         specify none for the <code>Forward</code> element.
     * @see ItemSelection
     */
    public final String forwardAsString() {
        return forward;
    }

    /**
     * <p>
     * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of this
     * field.
     * </p>
     * <p>
     * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you want to send cookies to the origin but not include them in the cache key, use an origin request policy.
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type that
     * specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior and, if
     * you want to forward selected cookies, the names of those cookies.
     * </p>
     * <p>
     * If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
     * <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from <code>whitelist</code> to
     * <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code> element and its
     * child elements, CloudFront deletes them automatically.
     * </p>
     * <p>
     * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront"> CloudFront
     * Limits</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
     *         this field.</p>
     *         <p>
     *         If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
     *         >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you want to send cookies to the origin but not include them in the cache key, use an origin request
     *         policy. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
     *         >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type that
     *         specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior
     *         and, if you want to forward selected cookies, the names of those cookies.
     *         </p>
     *         <p>
     *         If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
     *         <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
     *         <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the
     *         <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.
     *         </p>
     *         <p>
     *         For the current limit on the number of cookie names that you can whitelist for each cache behavior, see
     *         <a href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
     *         CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final CookieNames whitelistedNames() {
        return whitelistedNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forwardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(whitelistedNames());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookiePreference)) {
            return false;
        }
        CookiePreference other = (CookiePreference) obj;
        return Objects.equals(forwardAsString(), other.forwardAsString())
                && Objects.equals(whitelistedNames(), other.whitelistedNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CookiePreference").add("Forward", forwardAsString()).add("WhitelistedNames", whitelistedNames())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Forward":
            return Optional.ofNullable(clazz.cast(forwardAsString()));
        case "WhitelistedNames":
            return Optional.ofNullable(clazz.cast(whitelistedNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CookiePreference, T> g) {
        return obj -> g.apply((CookiePreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CookiePreference> {
        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use origin request policy.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
         * specified in the <code>WhitelistedNames</code> complex type.
         * </p>
         * <p>
         * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
         * specify none for the <code>Forward</code> element.
         * </p>
         * 
         * @param forward
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include cookies in the cache key, use a cache policy. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send cookies to the origin but not include them in the cache key, use origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
         *        cookies specified in the <code>WhitelistedNames</code> complex type.
         *        </p>
         *        <p>
         *        Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3
         *        origin, specify none for the <code>Forward</code> element.
         * @see ItemSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemSelection
         */
        Builder forward(String forward);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use origin request policy.
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of cookies
         * specified in the <code>WhitelistedNames</code> complex type.
         * </p>
         * <p>
         * Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3 origin,
         * specify none for the <code>Forward</code> element.
         * </p>
         * 
         * @param forward
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include cookies in the cache key, use a cache policy. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send cookies to the origin but not include them in the cache key, use origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifies which cookies to forward to the origin for this cache behavior: all, none, or the list of
         *        cookies specified in the <code>WhitelistedNames</code> complex type.
         *        </p>
         *        <p>
         *        Amazon S3 doesn't process cookies. When the cache behavior is forwarding requests to an Amazon S3
         *        origin, specify none for the <code>Forward</code> element.
         * @see ItemSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemSelection
         */
        Builder forward(ItemSelection forward);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type that
         * specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior
         * and, if you want to forward selected cookies, the names of those cookies.
         * </p>
         * <p>
         * If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
         * <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from <code>whitelist</code> to
         * <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code> element and its
         * child elements, CloudFront deletes them automatically.
         * </p>
         * <p>
         * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
         * CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param whitelistedNames
         *        This field is deprecated. We recommend that you use a cache policy or an origin request policy instead
         *        of this field.</p>
         *        <p>
         *        If you want to include cookies in the cache key, use a cache policy. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         *        >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you want to send cookies to the origin but not include them in the cache key, use an origin request
         *        policy. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         *        >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type
         *        that specifies how many different cookies you want CloudFront to forward to the origin for this cache
         *        behavior and, if you want to forward selected cookies, the names of those cookies.
         *        </p>
         *        <p>
         *        If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
         *        <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from
         *        <code>whitelist</code> to <code>all</code> or <code>none</code> and you don't delete the
         *        <code>WhitelistedNames</code> element and its child elements, CloudFront deletes them automatically.
         *        </p>
         *        <p>
         *        For the current limit on the number of cookie names that you can whitelist for each cache behavior,
         *        see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
         *        CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whitelistedNames(CookieNames whitelistedNames);

        /**
         * <p>
         * This field is deprecated. We recommend that you use a cache policy or an origin request policy instead of
         * this field.
         * </p>
         * <p>
         * If you want to include cookies in the cache key, use a cache policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-key-create-cache-policy"
         * >Creating cache policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you want to send cookies to the origin but not include them in the cache key, use an origin request
         * policy. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html#origin-request-create-origin-request-policy"
         * >Creating origin request policies</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * Required if you specify <code>whitelist</code> for the value of <code>Forward</code>. A complex type that
         * specifies how many different cookies you want CloudFront to forward to the origin for this cache behavior
         * and, if you want to forward selected cookies, the names of those cookies.
         * </p>
         * <p>
         * If you specify <code>all</code> or <code>none</code> for the value of <code>Forward</code>, omit
         * <code>WhitelistedNames</code>. If you change the value of <code>Forward</code> from <code>whitelist</code> to
         * <code>all</code> or <code>none</code> and you don't delete the <code>WhitelistedNames</code> element and its
         * child elements, CloudFront deletes them automatically.
         * </p>
         * <p>
         * For the current limit on the number of cookie names that you can whitelist for each cache behavior, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/xrefaws_service_limits.html#limits_cloudfront">
         * CloudFront Limits</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CookieNames.Builder} avoiding the need to
         * create one manually via {@link CookieNames#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CookieNames.Builder#build()} is called immediately and its result
         * is passed to {@link #whitelistedNames(CookieNames)}.
         * 
         * @param whitelistedNames
         *        a consumer that will call methods on {@link CookieNames.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #whitelistedNames(CookieNames)
         */
        default Builder whitelistedNames(Consumer<CookieNames.Builder> whitelistedNames) {
            return whitelistedNames(CookieNames.builder().applyMutation(whitelistedNames).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String forward;

        private CookieNames whitelistedNames;

        private BuilderImpl() {
        }

        private BuilderImpl(CookiePreference model) {
            forward(model.forward);
            whitelistedNames(model.whitelistedNames);
        }

        public final String getForward() {
            return forward;
        }

        public final void setForward(String forward) {
            this.forward = forward;
        }

        @Override
        public final Builder forward(String forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public final Builder forward(ItemSelection forward) {
            this.forward(forward == null ? null : forward.toString());
            return this;
        }

        public final CookieNames.Builder getWhitelistedNames() {
            return whitelistedNames != null ? whitelistedNames.toBuilder() : null;
        }

        public final void setWhitelistedNames(CookieNames.BuilderImpl whitelistedNames) {
            this.whitelistedNames = whitelistedNames != null ? whitelistedNames.build() : null;
        }

        @Override
        public final Builder whitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
            return this;
        }

        @Override
        public CookiePreference build() {
            return new CookiePreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
