/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of accounts and the active CloudFront key pairs in each account that CloudFront can use to verify the
 * signatures of signed URLs and signed cookies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Signer implements SdkPojo, Serializable, ToCopyableBuilder<Signer.Builder, Signer> {
    private static final SdkField<String> AWS_ACCOUNT_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountNumber")
            .getter(getter(Signer::awsAccountNumber))
            .setter(setter(Builder::awsAccountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountNumber")
                    .unmarshallLocationName("AwsAccountNumber").build()).build();

    private static final SdkField<KeyPairIds> KEY_PAIR_IDS_FIELD = SdkField
            .<KeyPairIds> builder(MarshallingType.SDK_POJO)
            .memberName("KeyPairIds")
            .getter(getter(Signer::keyPairIds))
            .setter(setter(Builder::keyPairIds))
            .constructor(KeyPairIds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairIds")
                    .unmarshallLocationName("KeyPairIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_NUMBER_FIELD,
            KEY_PAIR_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsAccountNumber;

    private final KeyPairIds keyPairIds;

    private Signer(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.keyPairIds = builder.keyPairIds;
    }

    /**
     * <p>
     * An account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures of
     * signed URLs and signed cookies. If the account that owns the key pairs is the same account that owns the
     * CloudFront distribution, the value of this field is <code>self</code>.
     * </p>
     * 
     * @return An account number that contains active CloudFront key pairs that CloudFront can use to verify the
     *         signatures of signed URLs and signed cookies. If the account that owns the key pairs is the same account
     *         that owns the CloudFront distribution, the value of this field is <code>self</code>.
     */
    public final String awsAccountNumber() {
        return awsAccountNumber;
    }

    /**
     * <p>
     * A list of CloudFront key pair identifiers.
     * </p>
     * 
     * @return A list of CloudFront key pair identifiers.
     */
    public final KeyPairIds keyPairIds() {
        return keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signer)) {
            return false;
        }
        Signer other = (Signer) obj;
        return Objects.equals(awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(keyPairIds(), other.keyPairIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Signer").add("AwsAccountNumber", awsAccountNumber()).add("KeyPairIds", keyPairIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountNumber":
            return Optional.ofNullable(clazz.cast(awsAccountNumber()));
        case "KeyPairIds":
            return Optional.ofNullable(clazz.cast(keyPairIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Signer, T> g) {
        return obj -> g.apply((Signer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Signer> {
        /**
         * <p>
         * An account number that contains active CloudFront key pairs that CloudFront can use to verify the signatures
         * of signed URLs and signed cookies. If the account that owns the key pairs is the same account that owns the
         * CloudFront distribution, the value of this field is <code>self</code>.
         * </p>
         * 
         * @param awsAccountNumber
         *        An account number that contains active CloudFront key pairs that CloudFront can use to verify the
         *        signatures of signed URLs and signed cookies. If the account that owns the key pairs is the same
         *        account that owns the CloudFront distribution, the value of this field is <code>self</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountNumber(String awsAccountNumber);

        /**
         * <p>
         * A list of CloudFront key pair identifiers.
         * </p>
         * 
         * @param keyPairIds
         *        A list of CloudFront key pair identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(KeyPairIds keyPairIds);

        /**
         * <p>
         * A list of CloudFront key pair identifiers.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyPairIds.Builder} avoiding the need to create
         * one manually via {@link KeyPairIds#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPairIds.Builder#build()} is called immediately and its result
         * is passed to {@link #keyPairIds(KeyPairIds)}.
         * 
         * @param keyPairIds
         *        a consumer that will call methods on {@link KeyPairIds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPairIds(KeyPairIds)
         */
        default Builder keyPairIds(Consumer<KeyPairIds.Builder> keyPairIds) {
            return keyPairIds(KeyPairIds.builder().applyMutation(keyPairIds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountNumber;

        private KeyPairIds keyPairIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Signer model) {
            awsAccountNumber(model.awsAccountNumber);
            keyPairIds(model.keyPairIds);
        }

        public final String getAwsAccountNumber() {
            return awsAccountNumber;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        @Override
        @Transient
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final KeyPairIds.Builder getKeyPairIds() {
            return keyPairIds != null ? keyPairIds.toBuilder() : null;
        }

        public final void setKeyPairIds(KeyPairIds.BuilderImpl keyPairIds) {
            this.keyPairIds = keyPairIds != null ? keyPairIds.build() : null;
        }

        @Override
        @Transient
        public final Builder keyPairIds(KeyPairIds keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        @Override
        public Signer build() {
            return new Signer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
