/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMonitoringSubscriptionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateMonitoringSubscriptionResponse.Builder, CreateMonitoringSubscriptionResponse> {
    private static final SdkField<MonitoringSubscription> MONITORING_SUBSCRIPTION_FIELD = SdkField
            .<MonitoringSubscription> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringSubscription")
            .getter(getter(CreateMonitoringSubscriptionResponse::monitoringSubscription))
            .setter(setter(Builder::monitoringSubscription))
            .constructor(MonitoringSubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSubscription")
                    .unmarshallLocationName("MonitoringSubscription").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MONITORING_SUBSCRIPTION_FIELD));

    private final MonitoringSubscription monitoringSubscription;

    private CreateMonitoringSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringSubscription = builder.monitoringSubscription;
    }

    /**
     * <p>
     * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are
     * enabled for a given CloudFront distribution.
     * </p>
     * 
     * @return A monitoring subscription. This structure contains information about whether additional CloudWatch
     *         metrics are enabled for a given CloudFront distribution.
     */
    public final MonitoringSubscription monitoringSubscription() {
        return monitoringSubscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringSubscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitoringSubscriptionResponse)) {
            return false;
        }
        CreateMonitoringSubscriptionResponse other = (CreateMonitoringSubscriptionResponse) obj;
        return Objects.equals(monitoringSubscription(), other.monitoringSubscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMonitoringSubscriptionResponse").add("MonitoringSubscription", monitoringSubscription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringSubscription":
            return Optional.ofNullable(clazz.cast(monitoringSubscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitoringSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateMonitoringSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMonitoringSubscriptionResponse> {
        /**
         * <p>
         * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics
         * are enabled for a given CloudFront distribution.
         * </p>
         * 
         * @param monitoringSubscription
         *        A monitoring subscription. This structure contains information about whether additional CloudWatch
         *        metrics are enabled for a given CloudFront distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringSubscription(MonitoringSubscription monitoringSubscription);

        /**
         * <p>
         * A monitoring subscription. This structure contains information about whether additional CloudWatch metrics
         * are enabled for a given CloudFront distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringSubscription.Builder} avoiding the
         * need to create one manually via {@link MonitoringSubscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringSubscription.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringSubscription(MonitoringSubscription)}.
         * 
         * @param monitoringSubscription
         *        a consumer that will call methods on {@link MonitoringSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringSubscription(MonitoringSubscription)
         */
        default Builder monitoringSubscription(Consumer<MonitoringSubscription.Builder> monitoringSubscription) {
            return monitoringSubscription(MonitoringSubscription.builder().applyMutation(monitoringSubscription).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private MonitoringSubscription monitoringSubscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitoringSubscriptionResponse model) {
            super(model);
            monitoringSubscription(model.monitoringSubscription);
        }

        public final MonitoringSubscription.Builder getMonitoringSubscription() {
            return monitoringSubscription != null ? monitoringSubscription.toBuilder() : null;
        }

        public final void setMonitoringSubscription(MonitoringSubscription.BuilderImpl monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription != null ? monitoringSubscription.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoringSubscription(MonitoringSubscription monitoringSubscription) {
            this.monitoringSubscription = monitoringSubscription;
            return this;
        }

        @Override
        public CreateMonitoringSubscriptionResponse build() {
            return new CreateMonitoringSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
