/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HttpVersion {
    HTTP1_1("http1.1"),
    HTTP2("http2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HttpVersion> VALUE_MAP;
    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpVersion> knownValues() {
        EnumSet<HttpVersion> knownValues = EnumSet.allOf(HttpVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HttpVersion.class, HttpVersion::toString);
    }
}

