/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.KinesisStreamConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndPoint> {
    private static final SdkField<String> STREAM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamType").getter(EndPoint.getter(EndPoint::streamType)).setter(EndPoint.setter(Builder::streamType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamType").unmarshallLocationName("StreamType").build()}).build();
    private static final SdkField<KinesisStreamConfig> KINESIS_STREAM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamConfig").getter(EndPoint.getter(EndPoint::kinesisStreamConfig)).setter(EndPoint.setter(Builder::kinesisStreamConfig)).constructor(KinesisStreamConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamConfig").unmarshallLocationName("KinesisStreamConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_TYPE_FIELD, KINESIS_STREAM_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamType;
    private final KinesisStreamConfig kinesisStreamConfig;

    private EndPoint(BuilderImpl builder) {
        this.streamType = builder.streamType;
        this.kinesisStreamConfig = builder.kinesisStreamConfig;
    }

    public final String streamType() {
        return this.streamType;
    }

    public final KinesisStreamConfig kinesisStreamConfig() {
        return this.kinesisStreamConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndPoint)) {
            return false;
        }
        EndPoint other = (EndPoint)obj;
        return Objects.equals(this.streamType(), other.streamType()) && Objects.equals(this.kinesisStreamConfig(), other.kinesisStreamConfig());
    }

    public final String toString() {
        return ToString.builder((String)"EndPoint").add("StreamType", (Object)this.streamType()).add("KinesisStreamConfig", (Object)this.kinesisStreamConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamType": {
                return Optional.ofNullable(clazz.cast(this.streamType()));
            }
            case "KinesisStreamConfig": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndPoint, T> g) {
        return obj -> g.apply((EndPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamType;
        private KinesisStreamConfig kinesisStreamConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EndPoint model) {
            this.streamType(model.streamType);
            this.kinesisStreamConfig(model.kinesisStreamConfig);
        }

        public final String getStreamType() {
            return this.streamType;
        }

        public final void setStreamType(String streamType) {
            this.streamType = streamType;
        }

        @Override
        @Transient
        public final Builder streamType(String streamType) {
            this.streamType = streamType;
            return this;
        }

        public final KinesisStreamConfig.Builder getKinesisStreamConfig() {
            return this.kinesisStreamConfig != null ? this.kinesisStreamConfig.toBuilder() : null;
        }

        public final void setKinesisStreamConfig(KinesisStreamConfig.BuilderImpl kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig != null ? kinesisStreamConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        public EndPoint build() {
            return new EndPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndPoint> {
        public Builder streamType(String var1);

        public Builder kinesisStreamConfig(KinesisStreamConfig var1);

        default public Builder kinesisStreamConfig(Consumer<KinesisStreamConfig.Builder> kinesisStreamConfig) {
            return this.kinesisStreamConfig((KinesisStreamConfig)((KinesisStreamConfig.Builder)KinesisStreamConfig.builder().applyMutation(kinesisStreamConfig)).build());
        }
    }
}

