/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOriginRequestPoliciesResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListOriginRequestPoliciesResponse.Builder, ListOriginRequestPoliciesResponse> {
    private static final SdkField<OriginRequestPolicyList> ORIGIN_REQUEST_POLICY_LIST_FIELD = SdkField
            .<OriginRequestPolicyList> builder(MarshallingType.SDK_POJO)
            .memberName("OriginRequestPolicyList")
            .getter(getter(ListOriginRequestPoliciesResponse::originRequestPolicyList))
            .setter(setter(Builder::originRequestPolicyList))
            .constructor(OriginRequestPolicyList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginRequestPolicyList")
                    .unmarshallLocationName("OriginRequestPolicyList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORIGIN_REQUEST_POLICY_LIST_FIELD));

    private final OriginRequestPolicyList originRequestPolicyList;

    private ListOriginRequestPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.originRequestPolicyList = builder.originRequestPolicyList;
    }

    /**
     * <p>
     * A list of origin request policies.
     * </p>
     * 
     * @return A list of origin request policies.
     */
    public final OriginRequestPolicyList originRequestPolicyList() {
        return originRequestPolicyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originRequestPolicyList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginRequestPoliciesResponse)) {
            return false;
        }
        ListOriginRequestPoliciesResponse other = (ListOriginRequestPoliciesResponse) obj;
        return Objects.equals(originRequestPolicyList(), other.originRequestPolicyList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOriginRequestPoliciesResponse").add("OriginRequestPolicyList", originRequestPolicyList())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginRequestPolicyList":
            return Optional.ofNullable(clazz.cast(originRequestPolicyList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOriginRequestPoliciesResponse, T> g) {
        return obj -> g.apply((ListOriginRequestPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOriginRequestPoliciesResponse> {
        /**
         * <p>
         * A list of origin request policies.
         * </p>
         * 
         * @param originRequestPolicyList
         *        A list of origin request policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originRequestPolicyList(OriginRequestPolicyList originRequestPolicyList);

        /**
         * <p>
         * A list of origin request policies.
         * </p>
         * This is a convenience that creates an instance of the {@link OriginRequestPolicyList.Builder} avoiding the
         * need to create one manually via {@link OriginRequestPolicyList#builder()}.
         *
         * When the {@link Consumer} completes, {@link OriginRequestPolicyList.Builder#build()} is called immediately
         * and its result is passed to {@link #originRequestPolicyList(OriginRequestPolicyList)}.
         * 
         * @param originRequestPolicyList
         *        a consumer that will call methods on {@link OriginRequestPolicyList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originRequestPolicyList(OriginRequestPolicyList)
         */
        default Builder originRequestPolicyList(Consumer<OriginRequestPolicyList.Builder> originRequestPolicyList) {
            return originRequestPolicyList(OriginRequestPolicyList.builder().applyMutation(originRequestPolicyList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private OriginRequestPolicyList originRequestPolicyList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginRequestPoliciesResponse model) {
            super(model);
            originRequestPolicyList(model.originRequestPolicyList);
        }

        public final OriginRequestPolicyList.Builder getOriginRequestPolicyList() {
            return originRequestPolicyList != null ? originRequestPolicyList.toBuilder() : null;
        }

        public final void setOriginRequestPolicyList(OriginRequestPolicyList.BuilderImpl originRequestPolicyList) {
            this.originRequestPolicyList = originRequestPolicyList != null ? originRequestPolicyList.build() : null;
        }

        @Override
        @Transient
        public final Builder originRequestPolicyList(OriginRequestPolicyList originRequestPolicyList) {
            this.originRequestPolicyList = originRequestPolicyList;
            return this;
        }

        @Override
        public ListOriginRequestPoliciesResponse build() {
            return new ListOriginRequestPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
