/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CloudFront function that is associated with a cache behavior in a CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionAssociation.Builder, FunctionAssociation> {
    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FunctionARN")
            .getter(getter(FunctionAssociation::functionARN))
            .setter(setter(Builder::functionARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionARN")
                    .unmarshallLocationName("FunctionARN").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EventType")
            .getter(getter(FunctionAssociation::eventTypeAsString))
            .setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType")
                    .unmarshallLocationName("EventType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_ARN_FIELD,
            EVENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionARN;

    private final String eventType;

    private FunctionAssociation(BuilderImpl builder) {
        this.functionARN = builder.functionARN;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function.
     */
    public final String functionARN() {
        return functionARN;
    }

    /**
     * <p>
     * The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You cannot
     * use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
     * function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You
     *         cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with
     *         a CloudFront function.
     * @see EventType
     */
    public final EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You cannot
     * use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with a CloudFront
     * function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You
     *         cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with
     *         a CloudFront function.
     * @see EventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionARN());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionAssociation)) {
            return false;
        }
        FunctionAssociation other = (FunctionAssociation) obj;
        return Objects.equals(functionARN(), other.functionARN())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionAssociation").add("FunctionARN", functionARN()).add("EventType", eventTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionARN":
            return Optional.ofNullable(clazz.cast(functionARN()));
        case "EventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionAssociation, T> g) {
        return obj -> g.apply((FunctionAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionAssociation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function.
         * </p>
         * 
         * @param functionARN
         *        The Amazon Resource Name (ARN) of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionARN(String functionARN);

        /**
         * <p>
         * The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You
         * cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with a
         * CloudFront function.
         * </p>
         * 
         * @param eventType
         *        The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>.
         *        You cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>
         *        ) with a CloudFront function.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>. You
         * cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>) with a
         * CloudFront function.
         * </p>
         * 
         * @param eventType
         *        The event type of the function, either <code>viewer-request</code> or <code>viewer-response</code>.
         *        You cannot use origin-facing event types (<code>origin-request</code> and <code>origin-response</code>
         *        ) with a CloudFront function.
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);
    }

    static final class BuilderImpl implements Builder {
        private String functionARN;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionAssociation model) {
            functionARN(model.functionARN);
            eventType(model.eventType);
        }

        public final String getFunctionARN() {
            return functionARN;
        }

        public final void setFunctionARN(String functionARN) {
            this.functionARN = functionARN;
        }

        @Override
        @Transient
        public final Builder functionARN(String functionARN) {
            this.functionARN = functionARN;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        @Transient
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @Transient
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        @Override
        public FunctionAssociation build() {
            return new FunctionAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
