/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a cache policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachePolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CachePolicySummary.Builder, CachePolicySummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(CachePolicySummary::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<CachePolicy> CACHE_POLICY_FIELD = SdkField
            .<CachePolicy> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicy")
            .getter(getter(CachePolicySummary::cachePolicy))
            .setter(setter(Builder::cachePolicy))
            .constructor(CachePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicy")
                    .unmarshallLocationName("CachePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TYPE_FIELD, CACHE_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final CachePolicy cachePolicy;

    private CachePolicySummary(BuilderImpl builder) {
        this.type = builder.type;
        this.cachePolicy = builder.cachePolicy;
    }

    /**
     * <p>
     * The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code>
     * (created in this account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CachePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this account).
     * @see CachePolicyType
     */
    public final CachePolicyType type() {
        return CachePolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code>
     * (created in this account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CachePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this account).
     * @see CachePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The cache policy.
     * </p>
     * 
     * @return The cache policy.
     */
    public final CachePolicy cachePolicy() {
        return cachePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachePolicySummary)) {
            return false;
        }
        CachePolicySummary other = (CachePolicySummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(cachePolicy(), other.cachePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CachePolicySummary").add("Type", typeAsString()).add("CachePolicy", cachePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CachePolicy":
            return Optional.ofNullable(clazz.cast(cachePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CachePolicySummary, T> g) {
        return obj -> g.apply((CachePolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachePolicySummary> {
        /**
         * <p>
         * The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code>
         * (created in this account).
         * </p>
         * 
         * @param type
         *        The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this account).
         * @see CachePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or <code>custom</code>
         * (created in this account).
         * </p>
         * 
         * @param type
         *        The type of cache policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this account).
         * @see CachePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CachePolicyType
         */
        Builder type(CachePolicyType type);

        /**
         * <p>
         * The cache policy.
         * </p>
         * 
         * @param cachePolicy
         *        The cache policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicy(CachePolicy cachePolicy);

        /**
         * <p>
         * The cache policy.
         * </p>
         * This is a convenience that creates an instance of the {@link CachePolicy.Builder} avoiding the need to create
         * one manually via {@link CachePolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachePolicy.Builder#build()} is called immediately and its result
         * is passed to {@link #cachePolicy(CachePolicy)}.
         * 
         * @param cachePolicy
         *        a consumer that will call methods on {@link CachePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicy(CachePolicy)
         */
        default Builder cachePolicy(Consumer<CachePolicy.Builder> cachePolicy) {
            return cachePolicy(CachePolicy.builder().applyMutation(cachePolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private CachePolicy cachePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CachePolicySummary model) {
            type(model.type);
            cachePolicy(model.cachePolicy);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(CachePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final CachePolicy.Builder getCachePolicy() {
            return cachePolicy != null ? cachePolicy.toBuilder() : null;
        }

        public final void setCachePolicy(CachePolicy.BuilderImpl cachePolicy) {
            this.cachePolicy = cachePolicy != null ? cachePolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder cachePolicy(CachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        @Override
        public CachePolicySummary build() {
            return new CachePolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
