/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontAsyncWaiter;

/**
 * Service client for accessing CloudFront asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon CloudFront</fullname>
 * <p>
 * This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about
 * CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the <i>Amazon
 * CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudFrontAsyncClient extends SdkClient {
    String SERVICE_NAME = "cloudfront";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudfront";

    /**
     * Create a {@link CloudFrontAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFrontAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontAsyncClient}.
     */
    static CloudFrontAsyncClientBuilder builder() {
        return new DefaultCloudFrontAsyncClientBuilder();
    }

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that’s already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param associateAliasRequest
     * @return A Java Future containing the result of the AssociateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAliasResponse> associateAlias(AssociateAliasRequest associateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that’s already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateAliasRequest#builder()}
     * </p>
     *
     * @param associateAliasRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateAliasResponse> associateAlias(Consumer<AssociateAliasRequest.Builder> associateAliasRequest) {
        return associateAlias(AssociateAliasRequest.builder().applyMutation(associateAliasRequest).build());
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are automatically included in requests
     * that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that
     * matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the
     * cache key, use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCachePolicyRequest
     * @return A Java Future containing the result of the CreateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyCachePoliciesException You have reached the maximum number of cache policies for this account.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCachePolicyResponse> createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are automatically included in requests
     * that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that
     * matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the
     * cache key, use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCachePolicyRequest#builder()}
     * </p>
     *
     * @param createCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateCachePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyCachePoliciesException You have reached the maximum number of cache policies for this account.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateCachePolicyResponse> createCachePolicy(
            Consumer<CreateCachePolicyRequest.Builder> createCachePolicyRequest) {
        return createCachePolicy(CreateCachePolicyRequest.builder().applyMutation(createCachePolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the CreateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudFrontOriginAccessIdentityAlreadyExistsException If the <code>CallerReference</code> is a value
     *         you already sent in a previous request to create an identity but the content of the
     *         <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront
     *         returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyCloudFrontOriginAccessIdentitiesException Processing your request would cause you to exceed
     *         the maximum number of origin access identities allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to create a new origin access identity (OAI). An origin access identity
     *        is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or
     *        just some of your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the CreateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudFrontOriginAccessIdentityAlreadyExistsException If the <code>CallerReference</code> is a value
     *         you already sent in a previous request to create an identity but the content of the
     *         <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront
     *         returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyCloudFrontOriginAccessIdentitiesException Processing your request would cause you to exceed
     *         the maximum number of origin access identities allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(
            Consumer<CreateCloudFrontOriginAccessIdentityRequest.Builder> createCloudFrontOriginAccessIdentityRequest) {
        return createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(createCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to
     * be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code>
     * request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then
     * make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a
     * href
     * ="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return A Java Future containing the result of the CreateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to
     * be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code>
     * request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then
     * make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a
     * href
     * ="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDistributionRequest#builder()}
     * </p>
     *
     * @param createDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionRequest.Builder} to create a
     *        request. The request to create a new distribution.
     * @return A Java Future containing the result of the CreateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDistributionResponse> createDistribution(
            Consumer<CreateDistributionRequest.Builder> createDistributionRequest) {
        return createDistribution(CreateDistributionRequest.builder().applyMutation(createDistributionRequest).build());
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return A Java Future containing the result of the CreateDistributionWithTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionWithTagsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionWithTagsRequest.Builder} to create a
     *        request. The request to create a new distribution with tags.
     * @return A Java Future containing the result of the CreateDistributionWithTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(
            Consumer<CreateDistributionWithTagsRequest.Builder> createDistributionWithTagsRequest) {
        return createDistributionWithTags(CreateDistributionWithTagsRequest.builder()
                .applyMutation(createDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>FieldLevelEncryptionConfigAlreadyExistsException The specified configuration for field-level
     *         encryption already exists.</li>
     *         <li>TooManyFieldLevelEncryptionConfigsException The maximum number of configurations for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFieldLevelEncryptionConfigResponse> createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>FieldLevelEncryptionConfigAlreadyExistsException The specified configuration for field-level
     *         encryption already exists.</li>
     *         <li>TooManyFieldLevelEncryptionConfigsException The maximum number of configurations for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFieldLevelEncryptionConfigResponse> createFieldLevelEncryptionConfig(
            Consumer<CreateFieldLevelEncryptionConfigRequest.Builder> createFieldLevelEncryptionConfigRequest) {
        return createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(createFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionProfilesException The maximum number of profiles for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFieldLevelEncryptionProfileResponse> createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionProfilesException The maximum number of profiles for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFieldLevelEncryptionProfileResponse> createFieldLevelEncryptionProfile(
            Consumer<CreateFieldLevelEncryptionProfileRequest.Builder> createFieldLevelEncryptionProfileRequest) {
        return createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(createFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you’re ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it’s live, you can attach the
     * function to a distribution’s cache behavior, using the function’s ARN.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyFunctionsException You have reached the maximum number of CloudFront functions for this
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>FunctionAlreadyExistsException A function with the same name already exists in this account. To
     *         create a function, you must provide a unique name. To update an existing function, use
     *         <code>UpdateFunction</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you’re ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it’s live, you can attach the
     * function to a distribution’s cache behavior, using the function’s ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyFunctionsException You have reached the maximum number of CloudFront functions for this
     *         account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>FunctionAlreadyExistsException A function with the same name already exists in this account. To
     *         create a function, you must provide a unique name. To update an existing function, use
     *         <code>UpdateFunction</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest) {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return A Java Future containing the result of the CreateInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>BatchTooLargeException Invalidation batch specified is too large.</li>
     *         <li>TooManyInvalidationsInProgressException You have exceeded the maximum number of allowable InProgress
     *         invalidation batch requests, or invalidation objects.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvalidationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInvalidationRequest#builder()}
     * </p>
     *
     * @param createInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link CreateInvalidationRequest.Builder} to create a
     *        request. The request to create an invalidation.
     * @return A Java Future containing the result of the CreateInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>BatchTooLargeException Invalidation batch specified is too large.</li>
     *         <li>TooManyInvalidationsInProgressException You have exceeded the maximum number of allowable InProgress
     *         invalidation batch requests, or invalidation objects.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateInvalidationResponse> createInvalidation(
            Consumer<CreateInvalidationRequest.Builder> createInvalidationRequest) {
        return createInvalidation(CreateInvalidationRequest.builder().applyMutation(createInvalidationRequest).build());
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createKeyGroupRequest
     * @return A Java Future containing the result of the CreateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>TooManyKeyGroupsException You have reached the maximum number of key groups for this account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyGroupResponse> createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateKeyGroupRequest#builder()}
     * </p>
     *
     * @param createKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateKeyGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>TooManyKeyGroupsException You have reached the maximum number of key groups for this account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateKeyGroupResponse> createKeyGroup(Consumer<CreateKeyGroupRequest.Builder> createKeyGroupRequest) {
        return createKeyGroup(CreateKeyGroupRequest.builder().applyMutation(createKeyGroupRequest).build());
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the CreateMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitoringSubscriptionResponse> createMonitoringSubscription(
            CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitoringSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateMonitoringSubscriptionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitoringSubscriptionResponse> createMonitoringSubscription(
            Consumer<CreateMonitoringSubscriptionRequest.Builder> createMonitoringSubscriptionRequest) {
        return createMonitoringSubscription(CreateMonitoringSubscriptionRequest.builder()
                .applyMutation(createMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it’s attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     * @return A Java Future containing the result of the CreateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyOriginRequestPoliciesException You have reached the maximum number of origin request policies
     *         for this account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOriginRequestPolicyResponse> createOriginRequestPolicy(
            CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it’s attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link CreateOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyOriginRequestPoliciesException You have reached the maximum number of origin request policies
     *         for this account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOriginRequestPolicyResponse> createOriginRequestPolicy(
            Consumer<CreateOriginRequestPolicyRequest.Builder> createOriginRequestPolicyRequest) {
        return createOriginRequestPolicy(CreateOriginRequestPolicyRequest.builder()
                .applyMutation(createOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return A Java Future containing the result of the CreatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PublicKeyAlreadyExistsException The specified public key already exists.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysException The maximum number of public keys for field-level encryption have been
     *         created. To create a new public key, delete one of the existing keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePublicKeyResponse> createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePublicKeyRequest#builder()}
     * </p>
     *
     * @param createPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreatePublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PublicKeyAlreadyExistsException The specified public key already exists.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysException The maximum number of public keys for field-level encryption have been
     *         created. To create a new public key, delete one of the existing keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePublicKeyResponse> createPublicKey(
            Consumer<CreatePublicKeyRequest.Builder> createPublicKeyRequest) {
        return createPublicKey(CreatePublicKeyRequest.builder().applyMutation(createPublicKeyRequest).build());
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     * @return A Java Future containing the result of the CreateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RealtimeLogConfigAlreadyExistsException A real-time log configuration with this name already exists.
     *         You must provide a unique name. To modify an existing real-time log configuration, use
     *         <code>UpdateRealtimeLogConfig</code>.</li>
     *         <li>TooManyRealtimeLogConfigsException You have reached the maximum number of real-time log
     *         configurations for this account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRealtimeLogConfigResponse> createRealtimeLogConfig(
            CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RealtimeLogConfigAlreadyExistsException A real-time log configuration with this name already exists.
     *         You must provide a unique name. To modify an existing real-time log configuration, use
     *         <code>UpdateRealtimeLogConfig</code>.</li>
     *         <li>TooManyRealtimeLogConfigsException You have reached the maximum number of real-time log
     *         configurations for this account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRealtimeLogConfigResponse> createRealtimeLogConfig(
            Consumer<CreateRealtimeLogConfigRequest.Builder> createRealtimeLogConfigRequest) {
        return createRealtimeLogConfig(CreateRealtimeLogConfigRequest.builder().applyMutation(createRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return A Java Future containing the result of the CreateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionRequest.Builder} to create
     *        a request. The request to create a new streaming distribution.
     * @return A Java Future containing the result of the CreateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(
            Consumer<CreateStreamingDistributionRequest.Builder> createStreamingDistributionRequest) {
        return createStreamingDistribution(CreateStreamingDistributionRequest.builder()
                .applyMutation(createStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return A Java Future containing the result of the CreateStreamingDistributionWithTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionWithTagsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionWithTagsRequest.Builder} to
     *        create a request. The request to create a new streaming distribution with tags.
     * @return A Java Future containing the result of the CreateStreamingDistributionWithTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(
            Consumer<CreateStreamingDistributionWithTagsRequest.Builder> createStreamingDistributionWithTagsRequest) {
        return createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest.builder()
                .applyMutation(createStreamingDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     *
     * @param deleteCachePolicyRequest
     * @return A Java Future containing the result of the DeleteCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>CachePolicyInUseException Cannot delete the cache policy because it is attached to one or more cache
     *         behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCachePolicyResponse> deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCachePolicyRequest#builder()}
     * </p>
     *
     * @param deleteCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCachePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>CachePolicyInUseException Cannot delete the cache policy because it is attached to one or more cache
     *         behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteCachePolicyResponse> deleteCachePolicy(
            Consumer<DeleteCachePolicyRequest.Builder> deleteCachePolicyRequest) {
        return deleteCachePolicy(DeleteCachePolicyRequest.builder().applyMutation(deleteCachePolicyRequest).build());
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return A Java Future containing the result of the DeleteCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CloudFrontOriginAccessIdentityInUseException The Origin Access Identity specified is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. Deletes a origin access identity.
     * @return A Java Future containing the result of the DeleteCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CloudFrontOriginAccessIdentityInUseException The Origin Access Identity specified is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(
            Consumer<DeleteCloudFrontOriginAccessIdentityRequest.Builder> deleteCloudFrontOriginAccessIdentityRequest) {
        return deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(deleteCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the DeleteDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li> <li>DistributionNotDisabledException The specified
     *         CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li> <li>
     *         NoSuchDistributionException The specified distribution does not exist.</li> <li>
     *         PreconditionFailedException The precondition in one or more of the request fields evaluated to <code>
     *         false</code>.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDistributionRequest#builder()}
     * </p>
     *
     * @param deleteDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionRequest.Builder} to create a
     *        request. This action deletes a web distribution. To delete a web distribution using the CloudFront API,
     *        perform the following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the DeleteDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li> <li>DistributionNotDisabledException The specified
     *         CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li> <li>
     *         NoSuchDistributionException The specified distribution does not exist.</li> <li>
     *         PreconditionFailedException The precondition in one or more of the request fields evaluated to <code>
     *         false</code>.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDistributionResponse> deleteDistribution(
            Consumer<DeleteDistributionRequest.Builder> deleteDistributionRequest) {
        return deleteDistribution(DeleteDistributionRequest.builder().applyMutation(deleteDistributionRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionConfigInUseException The specified configuration for field-level encryption is in
     *         use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionConfigInUseException The specified configuration for field-level encryption is in
     *         use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> deleteFieldLevelEncryptionConfig(
            Consumer<DeleteFieldLevelEncryptionConfigRequest.Builder> deleteFieldLevelEncryptionConfigRequest) {
        return deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileInUseException The specified profile for field-level encryption is in use.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileInUseException The specified profile for field-level encryption is in use.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> deleteFieldLevelEncryptionProfile(
            Consumer<DeleteFieldLevelEncryptionProfileRequest.Builder> deleteFieldLevelEncryptionProfileRequest) {
        return deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>FunctionInUseException Cannot delete the function because it’s attached to one or more cache
     *         behaviors.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>FunctionInUseException Cannot delete the function because it’s attached to one or more cache
     *         behaviors.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest) {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group’s identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     *
     * @param deleteKeyGroupRequest
     * @return A Java Future containing the result of the DeleteKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>ResourceInUseException Cannot delete this resource because it is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyGroupResponse> deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group’s identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteKeyGroupRequest#builder()}
     * </p>
     *
     * @param deleteKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteKeyGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>ResourceInUseException Cannot delete this resource because it is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteKeyGroupResponse> deleteKeyGroup(Consumer<DeleteKeyGroupRequest.Builder> deleteKeyGroupRequest) {
        return deleteKeyGroup(DeleteKeyGroupRequest.builder().applyMutation(deleteKeyGroupRequest).build());
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the DeleteMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitoringSubscriptionResponse> deleteMonitoringSubscription(
            DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitoringSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMonitoringSubscriptionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitoringSubscriptionResponse> deleteMonitoringSubscription(
            Consumer<DeleteMonitoringSubscriptionRequest.Builder> deleteMonitoringSubscriptionRequest) {
        return deleteMonitoringSubscription(DeleteMonitoringSubscriptionRequest.builder()
                .applyMutation(deleteMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy’s identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     * @return A Java Future containing the result of the DeleteOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>OriginRequestPolicyInUseException Cannot delete the origin request policy because it is attached to
     *         one or more cache behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginRequestPolicyResponse> deleteOriginRequestPolicy(
            DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy’s identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>OriginRequestPolicyInUseException Cannot delete the origin request policy because it is attached to
     *         one or more cache behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOriginRequestPolicyResponse> deleteOriginRequestPolicy(
            Consumer<DeleteOriginRequestPolicyRequest.Builder> deleteOriginRequestPolicyRequest) {
        return deleteOriginRequestPolicy(DeleteOriginRequestPolicyRequest.builder()
                .applyMutation(deleteOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return A Java Future containing the result of the DeletePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>PublicKeyInUseException The specified public key is in use.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePublicKeyResponse> deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePublicKeyRequest#builder()}
     * </p>
     *
     * @param deletePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>PublicKeyInUseException The specified public key is in use.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePublicKeyResponse> deletePublicKey(
            Consumer<DeletePublicKeyRequest.Builder> deletePublicKeyRequest) {
        return deletePublicKey(DeletePublicKeyRequest.builder().applyMutation(deletePublicKeyRequest).build());
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     * @return A Java Future containing the result of the DeleteRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigInUseException Cannot delete the real-time log configuration because it is attached
     *         to one or more cache behaviors.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRealtimeLogConfigResponse> deleteRealtimeLogConfig(
            DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigInUseException Cannot delete the real-time log configuration because it is attached
     *         to one or more cache behaviors.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRealtimeLogConfigResponse> deleteRealtimeLogConfig(
            Consumer<DeleteRealtimeLogConfigRequest.Builder> deleteRealtimeLogConfigRequest) {
        return deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest.builder().applyMutation(deleteRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return A Java Future containing the result of the DeleteStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>StreamingDistributionNotDisabledException The specified CloudFront distribution is not disabled. You
     *         must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamingDistributionRequest.Builder} to create
     *        a request. The request to delete a streaming distribution.
     * @return A Java Future containing the result of the DeleteStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>StreamingDistributionNotDisabledException The specified CloudFront distribution is not disabled. You
     *         must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(
            Consumer<DeleteStreamingDistributionRequest.Builder> deleteStreamingDistributionRequest) {
        return deleteStreamingDistribution(DeleteStreamingDistributionRequest.builder()
                .applyMutation(deleteStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a
     * function’s code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function’s name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     *
     * @param describeFunctionRequest
     * @return A Java Future containing the result of the DescribeFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFunctionResponse> describeFunction(DescribeFunctionRequest describeFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a
     * function’s code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function’s name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFunctionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeFunctionRequest#builder()}
     * </p>
     *
     * @param describeFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFunctionResponse> describeFunction(
            Consumer<DescribeFunctionRequest.Builder> describeFunctionRequest) {
        return describeFunction(DescribeFunctionRequest.builder().applyMutation(describeFunctionRequest).build());
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is attached to a
     * distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyRequest
     * @return A Java Future containing the result of the GetCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCachePolicyResponse> getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is attached to a
     * distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCachePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetCachePolicyRequest#builder()}
     * </p>
     *
     * @param getCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetCachePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCachePolicyResponse> getCachePolicy(Consumer<GetCachePolicyRequest.Builder> getCachePolicyRequest) {
        return getCachePolicy(GetCachePolicyRequest.builder().applyMutation(getCachePolicyRequest).build());
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache policy is attached to
     * a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyConfigRequest
     * @return A Java Future containing the result of the GetCachePolicyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCachePolicyConfigResponse> getCachePolicyConfig(
            GetCachePolicyConfigRequest getCachePolicyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache policy is attached to
     * a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCachePolicyConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetCachePolicyConfigRequest#builder()}
     * </p>
     *
     * @param getCachePolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetCachePolicyConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCachePolicyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCachePolicyConfigResponse> getCachePolicyConfig(
            Consumer<GetCachePolicyConfigRequest.Builder> getCachePolicyConfigRequest) {
        return getCachePolicyConfig(GetCachePolicyConfigRequest.builder().applyMutation(getCachePolicyConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFrontOriginAccessIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetCloudFrontOriginAccessIdentityRequest.Builder} to
     *        create a request. The request to get an origin access identity's information.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(
            Consumer<GetCloudFrontOriginAccessIdentityRequest.Builder> getCloudFrontOriginAccessIdentityRequest) {
        return getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentityConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} to create a request. The origin access
     *        identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentityConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(
            Consumer<GetCloudFrontOriginAccessIdentityConfigRequest.Builder> getCloudFrontOriginAccessIdentityConfigRequest) {
        return getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return A Java Future containing the result of the GetDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionRequest.Builder} avoiding the need
     * to create one manually via {@link GetDistributionRequest#builder()}
     * </p>
     *
     * @param getDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionRequest.Builder} to create a request.
     *        The request to get a distribution's information.
     * @return A Java Future containing the result of the GetDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDistributionResponse> getDistribution(
            Consumer<GetDistributionRequest.Builder> getDistributionRequest) {
        return getDistribution(GetDistributionRequest.builder().applyMutation(getDistributionRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return A Java Future containing the result of the GetDistributionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(
            GetDistributionConfigRequest getDistributionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionConfigRequest.Builder} to create a
     *        request. The request to get a distribution configuration.
     * @return A Java Future containing the result of the GetDistributionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(
            Consumer<GetDistributionConfigRequest.Builder> getDistributionConfigRequest) {
        return getDistributionConfig(GetDistributionConfigRequest.builder().applyMutation(getDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionResponse> getFieldLevelEncryption(
            GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetFieldLevelEncryptionRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFieldLevelEncryption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionResponse> getFieldLevelEncryption(
            Consumer<GetFieldLevelEncryptionRequest.Builder> getFieldLevelEncryptionRequest) {
        return getFieldLevelEncryption(GetFieldLevelEncryptionRequest.builder().applyMutation(getFieldLevelEncryptionRequest)
                .build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionConfigResponse> getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionConfigResponse> getFieldLevelEncryptionConfig(
            Consumer<GetFieldLevelEncryptionConfigRequest.Builder> getFieldLevelEncryptionConfigRequest) {
        return getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionProfileResponse> getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionProfileResponse> getFieldLevelEncryptionProfile(
            Consumer<GetFieldLevelEncryptionProfileRequest.Builder> getFieldLevelEncryptionProfileRequest) {
        return getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfileConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetFieldLevelEncryptionProfileConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetFieldLevelEncryptionProfileConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfileConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> getFieldLevelEncryptionProfileConfig(
            Consumer<GetFieldLevelEncryptionProfileConfigRequest.Builder> getFieldLevelEncryptionProfileConfigRequest) {
        return getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileConfigRequest).build());
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function’s code, you must provide the function’s name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function’s code, you must provide the function’s name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return A Java Future containing the result of the GetInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchInvalidationException The specified invalidation does not exist.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvalidationRequest.Builder} avoiding the need
     * to create one manually via {@link GetInvalidationRequest#builder()}
     * </p>
     *
     * @param getInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link GetInvalidationRequest.Builder} to create a request.
     *        The request to get an invalidation's information.
     * @return A Java Future containing the result of the GetInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchInvalidationException The specified invalidation does not exist.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInvalidationResponse> getInvalidation(
            Consumer<GetInvalidationRequest.Builder> getInvalidationRequest) {
        return getInvalidation(GetInvalidationRequest.builder().applyMutation(getInvalidationRequest).build());
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group’s identifier. If the key group is referenced in a
     * distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupRequest
     * @return A Java Future containing the result of the GetKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyGroupResponse> getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group’s identifier. If the key group is referenced in a
     * distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetKeyGroupRequest#builder()}
     * </p>
     *
     * @param getKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetKeyGroupResponse> getKeyGroup(Consumer<GetKeyGroupRequest.Builder> getKeyGroupRequest) {
        return getKeyGroup(GetKeyGroupRequest.builder().applyMutation(getKeyGroupRequest).build());
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group’s identifier. If the key group is referenced in
     * a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupConfigRequest
     * @return A Java Future containing the result of the GetKeyGroupConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetKeyGroupConfigResponse> getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group’s identifier. If the key group is referenced in
     * a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKeyGroupConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetKeyGroupConfigRequest#builder()}
     * </p>
     *
     * @param getKeyGroupConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetKeyGroupConfigRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetKeyGroupConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetKeyGroupConfigResponse> getKeyGroupConfig(
            Consumer<GetKeyGroupConfigRequest.Builder> getKeyGroupConfigRequest) {
        return getKeyGroupConfig(GetKeyGroupConfigRequest.builder().applyMutation(getKeyGroupConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the GetMonitoringSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMonitoringSubscriptionResponse> getMonitoringSubscription(
            GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMonitoringSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetMonitoringSubscriptionRequest#builder()}
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link GetMonitoringSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMonitoringSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMonitoringSubscriptionResponse> getMonitoringSubscription(
            Consumer<GetMonitoringSubscriptionRequest.Builder> getMonitoringSubscriptionRequest) {
        return getMonitoringSubscription(GetMonitoringSubscriptionRequest.builder()
                .applyMutation(getMonitoringSubscriptionRequest).build());
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy’s identifier. If the origin request policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     * @return A Java Future containing the result of the GetOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginRequestPolicyResponse> getOriginRequestPolicy(
            GetOriginRequestPolicyRequest getOriginRequestPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy’s identifier. If the origin request policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginRequestPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginRequestPolicyResponse> getOriginRequestPolicy(
            Consumer<GetOriginRequestPolicyRequest.Builder> getOriginRequestPolicyRequest) {
        return getOriginRequestPolicy(GetOriginRequestPolicyRequest.builder().applyMutation(getOriginRequestPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy’s identifier. If the origin request
     * policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     * @return A Java Future containing the result of the GetOriginRequestPolicyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginRequestPolicyConfigResponse> getOriginRequestPolicyConfig(
            GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy’s identifier. If the origin request
     * policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOriginRequestPolicyConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetOriginRequestPolicyConfigRequest#builder()}
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetOriginRequestPolicyConfigRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetOriginRequestPolicyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOriginRequestPolicyConfigResponse> getOriginRequestPolicyConfig(
            Consumer<GetOriginRequestPolicyConfigRequest.Builder> getOriginRequestPolicyConfigRequest) {
        return getOriginRequestPolicyConfig(GetOriginRequestPolicyConfigRequest.builder()
                .applyMutation(getOriginRequestPolicyConfigRequest).build());
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return A Java Future containing the result of the GetPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPublicKeyRequest#builder()}
     * </p>
     *
     * @param getPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPublicKeyResponse> getPublicKey(Consumer<GetPublicKeyRequest.Builder> getPublicKeyRequest) {
        return getPublicKey(GetPublicKeyRequest.builder().applyMutation(getPublicKeyRequest).build());
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return A Java Future containing the result of the GetPublicKeyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPublicKeyConfigResponse> getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetPublicKeyConfigRequest#builder()}
     * </p>
     *
     * @param getPublicKeyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetPublicKeyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetPublicKeyConfigResponse> getPublicKeyConfig(
            Consumer<GetPublicKeyConfigRequest.Builder> getPublicKeyConfigRequest) {
        return getPublicKeyConfig(GetPublicKeyConfigRequest.builder().applyMutation(getPublicKeyConfigRequest).build());
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     * @return A Java Future containing the result of the GetRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRealtimeLogConfigResponse> getRealtimeLogConfig(
            GetRealtimeLogConfigRequest getRealtimeLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRealtimeLogConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRealtimeLogConfigResponse> getRealtimeLogConfig(
            Consumer<GetRealtimeLogConfigRequest.Builder> getRealtimeLogConfigRequest) {
        return getRealtimeLogConfig(GetRealtimeLogConfigRequest.builder().applyMutation(getRealtimeLogConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return A Java Future containing the result of the GetStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionRequest.Builder} avoiding
     * the need to create one manually via {@link GetStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionRequest.Builder} to create a
     *        request. The request to get a streaming distribution's information.
     * @return A Java Future containing the result of the GetStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(
            Consumer<GetStreamingDistributionRequest.Builder> getStreamingDistributionRequest) {
        return getStreamingDistribution(GetStreamingDistributionRequest.builder().applyMutation(getStreamingDistributionRequest)
                .build());
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return A Java Future containing the result of the GetStreamingDistributionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetStreamingDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionConfigRequest.Builder} to
     *        create a request. To request to get a streaming distribution configuration.
     * @return A Java Future containing the result of the GetStreamingDistributionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(
            Consumer<GetStreamingDistributionConfigRequest.Builder> getStreamingDistributionConfigRequest) {
        return getStreamingDistributionConfig(GetStreamingDistributionConfigRequest.builder()
                .applyMutation(getStreamingDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listCachePoliciesRequest
     * @return A Java Future containing the result of the ListCachePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCachePoliciesResponse> listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCachePoliciesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCachePoliciesRequest#builder()}
     * </p>
     *
     * @param listCachePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListCachePoliciesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCachePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCachePoliciesResponse> listCachePolicies(
            Consumer<ListCachePoliciesRequest.Builder> listCachePoliciesRequest) {
        return listCachePolicies(ListCachePoliciesRequest.builder().applyMutation(listCachePoliciesRequest).build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCloudFrontOriginAccessIdentitiesRequest#builder()}
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder}
     *        to create a request. The request to list origin access identities.
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(
            Consumer<ListCloudFrontOriginAccessIdentitiesRequest.Builder> listCloudFrontOriginAccessIdentitiesRequest) {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder()
                .applyMutation(listCloudFrontOriginAccessIdentitiesRequest).build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities() {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don’t own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listConflictingAliasesRequest
     * @return A Java Future containing the result of the ListConflictingAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConflictingAliasesResponse> listConflictingAliases(
            ListConflictingAliasesRequest listConflictingAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don’t own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConflictingAliasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListConflictingAliasesRequest#builder()}
     * </p>
     *
     * @param listConflictingAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListConflictingAliasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListConflictingAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListConflictingAliasesResponse> listConflictingAliases(
            Consumer<ListConflictingAliasesRequest.Builder> listConflictingAliasesRequest) {
        return listConflictingAliases(ListConflictingAliasesRequest.builder().applyMutation(listConflictingAliasesRequest)
                .build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDistributionsRequest#builder()}
     * </p>
     *
     * @param listDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsRequest.Builder} to create a request.
     *        The request to list your distributions.
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDistributionsResponse> listDistributions(
            Consumer<ListDistributionsRequest.Builder> listDistributionsRequest) {
        return listDistributions(ListDistributionsRequest.builder().applyMutation(listDistributionsRequest).build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDistributionsResponse> listDistributions() {
        return listDistributions(ListDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     * @return A Java Future containing the result of the ListDistributionsByCachePolicyId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByCachePolicyIdResponse> listDistributionsByCachePolicyId(
            ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByCachePolicyIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByCachePolicyIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByCachePolicyIdRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDistributionsByCachePolicyId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByCachePolicyIdResponse> listDistributionsByCachePolicyId(
            Consumer<ListDistributionsByCachePolicyIdRequest.Builder> listDistributionsByCachePolicyIdRequest) {
        return listDistributionsByCachePolicyId(ListDistributionsByCachePolicyIdRequest.builder()
                .applyMutation(listDistributionsByCachePolicyIdRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     * @return A Java Future containing the result of the ListDistributionsByKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByKeyGroupResponse> listDistributionsByKeyGroup(
            ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByKeyGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByKeyGroupRequest#builder()}
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByKeyGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDistributionsByKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByKeyGroupResponse> listDistributionsByKeyGroup(
            Consumer<ListDistributionsByKeyGroupRequest.Builder> listDistributionsByKeyGroupRequest) {
        return listDistributionsByKeyGroup(ListDistributionsByKeyGroupRequest.builder()
                .applyMutation(listDistributionsByKeyGroupRequest).build());
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     * @return A Java Future containing the result of the ListDistributionsByOriginRequestPolicyId operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> listDistributionsByOriginRequestPolicyId(
            ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDistributionsByOriginRequestPolicyIdRequest.Builder} avoiding the need to create one manually via
     * {@link ListDistributionsByOriginRequestPolicyIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     *        A {@link Consumer} that will call methods on
     *        {@link ListDistributionsByOriginRequestPolicyIdRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDistributionsByOriginRequestPolicyId operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> listDistributionsByOriginRequestPolicyId(
            Consumer<ListDistributionsByOriginRequestPolicyIdRequest.Builder> listDistributionsByOriginRequestPolicyIdRequest) {
        return listDistributionsByOriginRequestPolicyId(ListDistributionsByOriginRequestPolicyIdRequest.builder()
                .applyMutation(listDistributionsByOriginRequestPolicyIdRequest).build());
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     * @return A Java Future containing the result of the ListDistributionsByRealtimeLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> listDistributionsByRealtimeLogConfig(
            ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDistributionsByRealtimeLogConfigRequest.Builder} avoiding the need to create one manually via
     * {@link ListDistributionsByRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByRealtimeLogConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDistributionsByRealtimeLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> listDistributionsByRealtimeLogConfig(
            Consumer<ListDistributionsByRealtimeLogConfigRequest.Builder> listDistributionsByRealtimeLogConfigRequest) {
        return listDistributionsByRealtimeLogConfig(ListDistributionsByRealtimeLogConfigRequest.builder()
                .applyMutation(listDistributionsByRealtimeLogConfigRequest).build());
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified WAF web ACL.
     * @return A Java Future containing the result of the ListDistributionsByWebACLId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByWebAclIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByWebAclIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByWebACLIdRequest.Builder} to create
     *        a request. The request to list distributions that are associated with a specified WAF web ACL.
     * @return A Java Future containing the result of the ListDistributionsByWebACLId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(
            Consumer<ListDistributionsByWebAclIdRequest.Builder> listDistributionsByWebAclIdRequest) {
        return listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest.builder()
                .applyMutation(listDistributionsByWebAclIdRequest).build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return A Java Future containing the result of the ListFieldLevelEncryptionConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionConfigsRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionConfigsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFieldLevelEncryptionConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs(
            Consumer<ListFieldLevelEncryptionConfigsRequest.Builder> listFieldLevelEncryptionConfigsRequest) {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder()
                .applyMutation(listFieldLevelEncryptionConfigsRequest).build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @return A Java Future containing the result of the ListFieldLevelEncryptionConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs() {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return A Java Future containing the result of the ListFieldLevelEncryptionProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionProfilesRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionProfilesRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionProfilesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListFieldLevelEncryptionProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles(
            Consumer<ListFieldLevelEncryptionProfilesRequest.Builder> listFieldLevelEncryptionProfilesRequest) {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder()
                .applyMutation(listFieldLevelEncryptionProfilesRequest).build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @return A Java Future containing the result of the ListFieldLevelEncryptionProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles() {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return A Java Future containing the result of the ListInvalidations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvalidationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvalidationsRequest#builder()}
     * </p>
     *
     * @param listInvalidationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvalidationsRequest.Builder} to create a request.
     *        The request to list invalidations.
     * @return A Java Future containing the result of the ListInvalidations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInvalidationsResponse> listInvalidations(
            Consumer<ListInvalidationsRequest.Builder> listInvalidationsRequest) {
        return listInvalidations(ListInvalidationsRequest.builder().applyMutation(listInvalidationsRequest).build());
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listKeyGroupsRequest
     * @return A Java Future containing the result of the ListKeyGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListKeyGroupsResponse> listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListKeyGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListKeyGroupsRequest#builder()}
     * </p>
     *
     * @param listKeyGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListKeyGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListKeyGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListKeyGroupsResponse> listKeyGroups(Consumer<ListKeyGroupsRequest.Builder> listKeyGroupsRequest) {
        return listKeyGroups(ListKeyGroupsRequest.builder().applyMutation(listKeyGroupsRequest).build());
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     * @return A Java Future containing the result of the ListOriginRequestPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOriginRequestPoliciesResponse> listOriginRequestPolicies(
            ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginRequestPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListOriginRequestPoliciesRequest#builder()}
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListOriginRequestPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOriginRequestPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOriginRequestPoliciesResponse> listOriginRequestPolicies(
            Consumer<ListOriginRequestPoliciesRequest.Builder> listOriginRequestPoliciesRequest) {
        return listOriginRequestPolicies(ListOriginRequestPoliciesRequest.builder()
                .applyMutation(listOriginRequestPoliciesRequest).build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListPublicKeysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest) {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListPublicKeysResponse> listPublicKeys() {
        return listPublicKeys(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     * @return A Java Future containing the result of the ListRealtimeLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRealtimeLogConfigsResponse> listRealtimeLogConfigs(
            ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRealtimeLogConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRealtimeLogConfigsRequest#builder()}
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListRealtimeLogConfigsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListRealtimeLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRealtimeLogConfigsResponse> listRealtimeLogConfigs(
            Consumer<ListRealtimeLogConfigsRequest.Builder> listRealtimeLogConfigsRequest) {
        return listRealtimeLogConfigs(ListRealtimeLogConfigsRequest.builder().applyMutation(listRealtimeLogConfigsRequest)
                .build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingDistributionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStreamingDistributionsRequest#builder()}
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingDistributionsRequest.Builder} to create a
     *        request. The request to list your streaming distributions.
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(
            Consumer<ListStreamingDistributionsRequest.Builder> listStreamingDistributionsRequest) {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder()
                .applyMutation(listStreamingDistributionsRequest).build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions() {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. The request to list tags for a CloudFront resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution’s
     * cache behavior, using the function’s Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param publishFunctionRequest
     * @return A Java Future containing the result of the PublishFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishFunctionResponse> publishFunction(PublishFunctionRequest publishFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution’s
     * cache behavior, using the function’s Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishFunctionRequest.Builder} avoiding the need
     * to create one manually via {@link PublishFunctionRequest#builder()}
     * </p>
     *
     * @param publishFunctionRequest
     *        A {@link Consumer} that will call methods on {@link PublishFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PublishFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PublishFunctionResponse> publishFunction(
            Consumer<PublishFunctionRequest.Builder> publishFunctionRequest) {
        return publishFunction(PublishFunctionRequest.builder().applyMutation(publishFunctionRequest).build());
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request to add tags to a CloudFront resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function’s result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function’s name and version (<code>ETag</code> value) along with the event
     * object. To get the function’s name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param testFunctionRequest
     * @return A Java Future containing the result of the TestFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>TestFunctionFailedException The CloudFront function failed.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestFunctionResponse> testFunction(TestFunctionRequest testFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function’s result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function’s name and version (<code>ETag</code> value) along with the event
     * object. To get the function’s name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link TestFunctionRequest#builder()}
     * </p>
     *
     * @param testFunctionRequest
     *        A {@link Consumer} that will call methods on {@link TestFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TestFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>TestFunctionFailedException The CloudFront function failed.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TestFunctionResponse> testFunction(Consumer<TestFunctionRequest.Builder> testFunctionRequest) {
        return testFunction(TestFunctionRequest.builder().applyMutation(testFunctionRequest).build());
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request. The
     *        request to remove tags from a CloudFront resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateCachePolicyRequest
     * @return A Java Future containing the result of the UpdateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCachePolicyResponse> updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCachePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCachePolicyRequest#builder()}
     * </p>
     *
     * @param updateCachePolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCachePolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateCachePolicyResponse> updateCachePolicy(
            Consumer<UpdateCachePolicyRequest.Builder> updateCachePolicyRequest) {
        return updateCachePolicy(UpdateCachePolicyRequest.builder().applyMutation(updateCachePolicyRequest).build());
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return A Java Future containing the result of the UpdateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to update an origin access identity.
     * @return A Java Future containing the result of the UpdateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(
            Consumer<UpdateCloudFrontOriginAccessIdentityRequest.Builder> updateCloudFrontOriginAccessIdentityRequest) {
        return updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(updateCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a web distribution.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using this API action, follow the steps here to get the current configuration and
     * then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     * <p>
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the
     * updates.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console instead, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">
     * GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the
     * distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you must get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include your changes.
     * </p>
     * <important>
     * <p>
     * When you edit the XML file, be aware of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must strip out the ETag parameter that is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * Additional fields are required when you update a distribution. There may be fields included in the XML file for
     * features that you haven't configured for your distribution. This is expected and required to successfully update
     * the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns
     * an <code>IllegalUpdate</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </li>
     * </ul>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * request to confirm that your changes have propagated. When propagation is complete, the value of
     * <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return A Java Future containing the result of the UpdateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a web distribution.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using this API action, follow the steps here to get the current configuration and
     * then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     * <p>
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the
     * updates.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console instead, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">
     * GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the
     * distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you must get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include your changes.
     * </p>
     * <important>
     * <p>
     * When you edit the XML file, be aware of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must strip out the ETag parameter that is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * Additional fields are required when you update a distribution. There may be fields included in the XML file for
     * features that you haven't configured for your distribution. This is expected and required to successfully update
     * the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns
     * an <code>IllegalUpdate</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </li>
     * </ul>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * request to confirm that your changes have propagated. When propagation is complete, the value of
     * <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDistributionRequest#builder()}
     * </p>
     *
     * @param updateDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionRequest.Builder} to create a
     *        request. The request to update a distribution.
     * @return A Java Future containing the result of the UpdateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateDistributionResponse> updateDistribution(
            Consumer<UpdateDistributionRequest.Builder> updateDistributionRequest) {
        return updateDistribution(UpdateDistributionRequest.builder().applyMutation(updateDistributionRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> updateFieldLevelEncryptionConfig(
            Consumer<UpdateFieldLevelEncryptionConfigRequest.Builder> updateFieldLevelEncryptionConfigRequest) {
        return updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(updateFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> updateFieldLevelEncryptionProfile(
            Consumer<UpdateFieldLevelEncryptionProfileRequest.Builder> updateFieldLevelEncryptionProfileRequest) {
        return updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(updateFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function’s code or the comment that describes the function. You cannot update a function’s name.
     * </p>
     * <p>
     * To update a function, you provide the function’s name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param updateFunctionRequest
     * @return A Java Future containing the result of the UpdateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest updateFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function’s code or the comment that describes the function. You cannot update a function’s name.
     * </p>
     * <p>
     * To update a function, you provide the function’s name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFunctionRequest#builder()}
     * </p>
     *
     * @param updateFunctionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionResponse> updateFunction(Consumer<UpdateFunctionRequest.Builder> updateFunctionRequest) {
        return updateFunction(UpdateFunctionRequest.builder().applyMutation(updateFunctionRequest).build());
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateKeyGroupRequest
     * @return A Java Future containing the result of the UpdateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateKeyGroupResponse> updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateKeyGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateKeyGroupRequest#builder()}
     * </p>
     *
     * @param updateKeyGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateKeyGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateKeyGroupResponse> updateKeyGroup(Consumer<UpdateKeyGroupRequest.Builder> updateKeyGroupRequest) {
        return updateKeyGroup(UpdateKeyGroupRequest.builder().applyMutation(updateKeyGroupRequest).build());
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateOriginRequestPolicyRequest
     * @return A Java Future containing the result of the UpdateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOriginRequestPolicyResponse> updateOriginRequestPolicy(
            UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOriginRequestPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateOriginRequestPolicyRequest#builder()}
     * </p>
     *
     * @param updateOriginRequestPolicyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateOriginRequestPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOriginRequestPolicyResponse> updateOriginRequestPolicy(
            Consumer<UpdateOriginRequestPolicyRequest.Builder> updateOriginRequestPolicyRequest) {
        return updateOriginRequestPolicy(UpdateOriginRequestPolicyRequest.builder()
                .applyMutation(updateOriginRequestPolicyRequest).build());
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return A Java Future containing the result of the UpdatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CannotChangeImmutablePublicKeyFieldsException You can't change the value of a public key.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePublicKeyResponse> updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePublicKeyRequest#builder()}
     * </p>
     *
     * @param updatePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePublicKeyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CannotChangeImmutablePublicKeyFieldsException You can't change the value of a public key.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePublicKeyResponse> updatePublicKey(
            Consumer<UpdatePublicKeyRequest.Builder> updatePublicKeyRequest) {
        return updatePublicKey(UpdatePublicKeyRequest.builder().applyMutation(updatePublicKeyRequest).build());
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration’s <code>Name</code> or <code>ARN</code>.
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     * @return A Java Future containing the result of the UpdateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRealtimeLogConfigResponse> updateRealtimeLogConfig(
            UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration’s <code>Name</code> or <code>ARN</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRealtimeLogConfigRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateRealtimeLogConfigRequest#builder()}
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRealtimeLogConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRealtimeLogConfigResponse> updateRealtimeLogConfig(
            Consumer<UpdateRealtimeLogConfigRequest.Builder> updateRealtimeLogConfigRequest) {
        return updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest.builder().applyMutation(updateRealtimeLogConfigRequest)
                .build());
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return A Java Future containing the result of the UpdateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStreamingDistributionRequest.Builder} to create
     *        a request. The request to update a streaming distribution.
     * @return A Java Future containing the result of the UpdateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(
            Consumer<UpdateStreamingDistributionRequest.Builder> updateStreamingDistributionRequest) {
        return updateStreamingDistribution(UpdateStreamingDistributionRequest.builder()
                .applyMutation(updateStreamingDistributionRequest).build());
    }

    /**
     * Create an instance of {@link CloudFrontAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFrontAsyncWaiter}
     */
    default CloudFrontAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
