/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePublicKeyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdatePublicKeyRequest.Builder, UpdatePublicKeyRequest> {
    private static final SdkField<PublicKeyConfig> PUBLIC_KEY_CONFIG_FIELD = SdkField
            .<PublicKeyConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdatePublicKeyRequest::publicKeyConfig))
            .setter(setter(Builder::publicKeyConfig))
            .constructor(PublicKeyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyConfig")
                    .unmarshallLocationName("PublicKeyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdatePublicKeyRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdatePublicKeyRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_CONFIG_FIELD,
            ID_FIELD, IF_MATCH_FIELD));

    private final PublicKeyConfig publicKeyConfig;

    private final String id;

    private final String ifMatch;

    private UpdatePublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.publicKeyConfig = builder.publicKeyConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * Request to update public key information.
     * </p>
     * 
     * @return Request to update public key information.
     */
    public PublicKeyConfig publicKeyConfig() {
        return publicKeyConfig;
    }

    /**
     * <p>
     * ID of the public key to be updated.
     * </p>
     * 
     * @return ID of the public key to be updated.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the public key to update. For
     * example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the public key to update. For
     *         example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePublicKeyRequest)) {
            return false;
        }
        UpdatePublicKeyRequest other = (UpdatePublicKeyRequest) obj;
        return Objects.equals(publicKeyConfig(), other.publicKeyConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdatePublicKeyRequest").add("PublicKeyConfig", publicKeyConfig()).add("Id", id())
                .add("IfMatch", ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyConfig":
            return Optional.ofNullable(clazz.cast(publicKeyConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePublicKeyRequest, T> g) {
        return obj -> g.apply((UpdatePublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePublicKeyRequest> {
        /**
         * <p>
         * Request to update public key information.
         * </p>
         * 
         * @param publicKeyConfig
         *        Request to update public key information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyConfig(PublicKeyConfig publicKeyConfig);

        /**
         * <p>
         * Request to update public key information.
         * </p>
         * This is a convenience that creates an instance of the {@link PublicKeyConfig.Builder} avoiding the need to
         * create one manually via {@link PublicKeyConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicKeyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #publicKeyConfig(PublicKeyConfig)}.
         * 
         * @param publicKeyConfig
         *        a consumer that will call methods on {@link PublicKeyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKeyConfig(PublicKeyConfig)
         */
        default Builder publicKeyConfig(Consumer<PublicKeyConfig.Builder> publicKeyConfig) {
            return publicKeyConfig(PublicKeyConfig.builder().applyMutation(publicKeyConfig).build());
        }

        /**
         * <p>
         * ID of the public key to be updated.
         * </p>
         * 
         * @param id
         *        ID of the public key to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the public key to update. For
         * example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the public key to update.
         *        For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private PublicKeyConfig publicKeyConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePublicKeyRequest model) {
            super(model);
            publicKeyConfig(model.publicKeyConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final PublicKeyConfig.Builder getPublicKeyConfig() {
            return publicKeyConfig != null ? publicKeyConfig.toBuilder() : null;
        }

        @Override
        public final Builder publicKeyConfig(PublicKeyConfig publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig;
            return this;
        }

        public final void setPublicKeyConfig(PublicKeyConfig.BuilderImpl publicKeyConfig) {
            this.publicKeyConfig = publicKeyConfig != null ? publicKeyConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePublicKeyRequest build() {
            return new UpdatePublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
