/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that controls whether access logs are written for this streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingLoggingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingLoggingConfig.Builder, StreamingLoggingConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StreamingLoggingConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StreamingLoggingConfig::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StreamingLoggingConfig::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, BUCKET_FIELD,
            PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String bucket;

    private final String prefix;

    private StreamingLoggingConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
     * logging when you create a streaming distribution or if you want to disable logging for an existing streaming
     * distribution, specify <code>false</code> for <code>Enabled</code>, and specify <code>empty Bucket</code> and
     * <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values
     * for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
     *         enable logging when you create a streaming distribution or if you want to disable logging for an existing
     *         streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify
     *         <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
     *         <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the values
     *         are automatically deleted.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket to store the access logs in, for example,
     *         <code>myawslogbucket.s3.amazonaws.com</code>.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * An optional string that you want CloudFront to prefix to the access log filenames for this streaming
     * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a
     * prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
     * </p>
     * 
     * @return An optional string that you want CloudFront to prefix to the access log filenames for this streaming
     *         distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
     *         specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
     *         element.
     */
    public String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingLoggingConfig)) {
            return false;
        }
        StreamingLoggingConfig other = (StreamingLoggingConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StreamingLoggingConfig").add("Enabled", enabled()).add("Bucket", bucket())
                .add("Prefix", prefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingLoggingConfig, T> g) {
        return obj -> g.apply((StreamingLoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingLoggingConfig> {
        /**
         * <p>
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
         * logging when you create a streaming distribution or if you want to disable logging for an existing streaming
         * distribution, specify <code>false</code> for <code>Enabled</code>, and specify <code>empty Bucket</code> and
         * <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify
         * values for <code>Bucket</code> and <code>Prefix</code>, the values are automatically deleted.
         * </p>
         * 
         * @param enabled
         *        Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
         *        enable logging when you create a streaming distribution or if you want to disable logging for an
         *        existing streaming distribution, specify <code>false</code> for <code>Enabled</code>, and specify
         *        <code>empty Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
         *        <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>Prefix</code>, the
         *        values are automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon S3 bucket to store the access logs in, for example, <code>myawslogbucket.s3.amazonaws.com</code>.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket to store the access logs in, for example,
         *        <code>myawslogbucket.s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * An optional string that you want CloudFront to prefix to the access log filenames for this streaming
         * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
         * specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
         * element.
         * </p>
         * 
         * @param prefix
         *        An optional string that you want CloudFront to prefix to the access log filenames for this streaming
         *        distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want
         *        to specify a prefix, you still must include an empty <code>Prefix</code> element in the
         *        <code>Logging</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingLoggingConfig model) {
            enabled(model.enabled);
            bucket(model.bucket);
            prefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public StreamingLoggingConfig build() {
            return new StreamingLoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
