/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;

/**
 * Service client for accessing CloudFront. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon CloudFront</fullname>
 * <p>
 * This is the <i>Amazon CloudFront API Reference</i>. This guide is for developers who need detailed information about
 * CloudFront API actions, data types, and errors. For detailed information about CloudFront features, see the <i>Amazon
 * CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CloudFrontClient extends SdkClient {
    String SERVICE_NAME = "cloudfront";

    /**
     * Create a {@link CloudFrontClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudFrontClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudFrontClient}.
     */
    static CloudFrontClientBuilder builder() {
        return new DefaultCloudFrontClientBuilder();
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link CreateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link CreateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to create a new origin access identity (OAI). An origin access identity
     *        is a special CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or
     *        just some of your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            Consumer<CreateCloudFrontOriginAccessIdentityRequest.Builder> createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(createCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to
     * be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code>
     * request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then
     * make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a
     * href
     * ="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to
     * be delivered from, and the details about how to track and manage content delivery. Send a <code>POST</code>
     * request to the <code>/<i>CloudFront API version</i>/distribution</code>/<code>distribution ID</code> resource.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html"
     * >UpdateDistribution</a>, follow the steps included in the documentation to get the current configuration and then
     * make your updates. This helps to make sure that you include all of the required fields. To view a summary, see <a
     * href
     * ="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDistributionRequest#builder()}
     * </p>
     *
     * @param createDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionRequest.Builder} to create a
     *        request. The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDistributionResponse createDistribution(Consumer<CreateDistributionRequest.Builder> createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return createDistribution(CreateDistributionRequest.builder().applyMutation(createDistributionRequest).build());
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionWithTagsResponse createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException,
            DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, MissingBodyException,
            TooManyDistributionCnamEsException, TooManyDistributionsException, InvalidDefaultRootObjectException,
            InvalidRelativePathException, InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException,
            InvalidRequiredProtocolException, NoSuchOriginException, TooManyOriginsException,
            TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException,
            InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException,
            InconsistentQuantitiesException, TooManyCertificatesException, InvalidLocationCodeException,
            InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException, InvalidTtlOrderException,
            InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDistributionWithTagsRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateDistributionWithTagsRequest.Builder} to create a
     *        request. The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDistributionWithTagsResponse createDistributionWithTags(
            Consumer<CreateDistributionWithTagsRequest.Builder> createDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException, InvalidTaggingException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return createDistributionWithTags(CreateDistributionWithTagsRequest.builder()
                .applyMutation(createDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            Consumer<CreateFieldLevelEncryptionConfigRequest.Builder> createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        return createFieldLevelEncryptionConfig(CreateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(createFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            Consumer<CreateFieldLevelEncryptionProfileRequest.Builder> createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        return createFieldLevelEncryptionProfile(CreateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(createFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInvalidationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInvalidationRequest#builder()}
     * </p>
     *
     * @param createInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link CreateInvalidationRequest.Builder} to create a
     *        request. The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateInvalidationResponse createInvalidation(Consumer<CreateInvalidationRequest.Builder> createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createInvalidation(CreateInvalidationRequest.builder().applyMutation(createInvalidationRequest).build());
    }

    /**
     * <p>
     * Add a new public key to CloudFront to use, for example, for field-level encryption. You can add a maximum of 10
     * public keys with one AWS account.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add a new public key to CloudFront to use, for example, for field-level encryption. You can add a maximum of 10
     * public keys with one AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePublicKeyRequest#builder()}
     * </p>
     *
     * @param createPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link CreatePublicKeyRequest.Builder} to create a request.
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePublicKeyResponse createPublicKey(Consumer<CreatePublicKeyRequest.Builder> createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return createPublicKey(CreatePublicKeyRequest.builder().applyMutation(createPublicKeyRequest).build());
    }

    /**
     * <p>
     * Creates a new RTMP distribution. An RTMP distribution is similar to a web distribution, but an RTMP distribution
     * streams media files using the Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using HTTP.
     * </p>
     * <p>
     * To create a new distribution, submit a <code>POST</code> request to the <i>CloudFront API
     * version</i>/distribution resource. The request body must include a document with a
     * <i>StreamingDistributionConfig</i> element. The response echoes the <code>StreamingDistributionConfig</code>
     * element and returns other information about the RTMP distribution.
     * </p>
     * <p>
     * To get the status of your request, use the <i>GET StreamingDistribution</i> API action. When the value of
     * <code>Enabled</code> is <code>true</code> and the value of <code>Status</code> is <code>Deployed</code>, your
     * distribution is ready. A distribution usually deploys in less than 15 minutes.
     * </p>
     * <p>
     * For more information about web distributions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html">Working with
     * RTMP Distributions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Beginning with the 2012-05-05 version of the CloudFront API, we made substantial changes to the format of the XML
     * document that you include in the request body when you create or update a web distribution or an RTMP
     * distribution, and when you invalidate objects. With previous versions of the API, we discovered that it was too
     * easy to accidentally delete one or more values for an element that accepts multiple values, for example, CNAMEs
     * and trusted signers. Our changes for the 2012-05-05 release are intended to prevent these accidental deletions
     * and to notify you when there's a mismatch between the number of values you say you're specifying in the
     * <code>Quantity</code> element and the number of values specified.
     * </p>
     * </important>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionResponse createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException,
            StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            AccessDeniedException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new RTMP distribution. An RTMP distribution is similar to a web distribution, but an RTMP distribution
     * streams media files using the Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using HTTP.
     * </p>
     * <p>
     * To create a new distribution, submit a <code>POST</code> request to the <i>CloudFront API
     * version</i>/distribution resource. The request body must include a document with a
     * <i>StreamingDistributionConfig</i> element. The response echoes the <code>StreamingDistributionConfig</code>
     * element and returns other information about the RTMP distribution.
     * </p>
     * <p>
     * To get the status of your request, use the <i>GET StreamingDistribution</i> API action. When the value of
     * <code>Enabled</code> is <code>true</code> and the value of <code>Status</code> is <code>Deployed</code>, your
     * distribution is ready. A distribution usually deploys in less than 15 minutes.
     * </p>
     * <p>
     * For more information about web distributions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html">Working with
     * RTMP Distributions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * Beginning with the 2012-05-05 version of the CloudFront API, we made substantial changes to the format of the XML
     * document that you include in the request body when you create or update a web distribution or an RTMP
     * distribution, and when you invalidate objects. With previous versions of the API, we discovered that it was too
     * easy to accidentally delete one or more values for an element that accepts multiple values, for example, CNAMEs
     * and trusted signers. Our changes for the 2012-05-05 release are intended to prevent these accidental deletions
     * and to notify you when there's a mismatch between the number of values you say you're specifying in the
     * <code>Quantity</code> element and the number of values specified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionRequest.Builder} to create
     *        a request. The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionResponse createStreamingDistribution(
            Consumer<CreateStreamingDistributionRequest.Builder> createStreamingDistributionRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return createStreamingDistribution(CreateStreamingDistributionRequest.builder()
                .applyMutation(createStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * Create a new streaming distribution with tags.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            InvalidTaggingException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new streaming distribution with tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingDistributionWithTagsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStreamingDistributionWithTagsRequest#builder()}
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingDistributionWithTagsRequest.Builder} to
     *        create a request. The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            Consumer<CreateStreamingDistributionWithTagsRequest.Builder> createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            InvalidTaggingException, AwsServiceException, SdkClientException, CloudFrontException {
        return createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest.builder()
                .applyMutation(createStreamingDistributionWithTagsRequest).build());
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            Consumer<DeleteCloudFrontOriginAccessIdentityRequest.Builder> deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(deleteCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDistributionRequest#builder()}
     * </p>
     *
     * @param deleteDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDistributionRequest.Builder} to create a
     *        request. This action deletes a web distribution. To delete a web distribution using the CloudFront API,
     *        perform the following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDistributionResponse deleteDistribution(Consumer<DeleteDistributionRequest.Builder> deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteDistribution(DeleteDistributionRequest.builder().applyMutation(deleteDistributionRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            Consumer<DeleteFieldLevelEncryptionConfigRequest.Builder> deleteFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException,
            PreconditionFailedException, FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteFieldLevelEncryptionConfig(DeleteFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            Consumer<DeleteFieldLevelEncryptionProfileRequest.Builder> deleteFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException,
            PreconditionFailedException, FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteFieldLevelEncryptionProfile(DeleteFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(deleteFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeletePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException,
            PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePublicKeyRequest#builder()}
     * </p>
     *
     * @param deletePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePublicKeyRequest.Builder} to create a request.
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeletePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePublicKeyResponse deletePublicKey(Consumer<DeletePublicKeyRequest.Builder> deletePublicKeyRequest)
            throws AccessDeniedException, PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        return deletePublicKey(DeletePublicKeyRequest.builder().applyMutation(deletePublicKeyRequest).build());
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStreamingDistributionResponse deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException,
            StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamingDistributionRequest.Builder} to create
     *        a request. The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteStreamingDistributionResponse deleteStreamingDistribution(
            Consumer<DeleteStreamingDistributionRequest.Builder> deleteStreamingDistributionRequest)
            throws AccessDeniedException, StreamingDistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchStreamingDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return deleteStreamingDistribution(DeleteStreamingDistributionRequest.builder()
                .applyMutation(deleteStreamingDistributionRequest).build());
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudFrontOriginAccessIdentityRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetCloudFrontOriginAccessIdentityRequest.Builder} to
     *        create a request. The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            Consumer<GetCloudFrontOriginAccessIdentityRequest.Builder> getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetCloudFrontOriginAccessIdentityConfigRequest#builder()}
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetCloudFrontOriginAccessIdentityConfigRequest.Builder} to create a request. The origin access
     *        identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            Consumer<GetCloudFrontOriginAccessIdentityConfigRequest.Builder> getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest.builder()
                .applyMutation(getCloudFrontOriginAccessIdentityConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistribution" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionRequest.Builder} avoiding the need
     * to create one manually via {@link GetDistributionRequest#builder()}
     * </p>
     *
     * @param getDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionRequest.Builder} to create a request.
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistribution" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDistributionResponse getDistribution(Consumer<GetDistributionRequest.Builder> getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getDistribution(GetDistributionRequest.builder().applyMutation(getDistributionRequest).build());
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDistributionConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetDistributionConfigRequest.Builder} to create a
     *        request. The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDistributionConfigResponse getDistributionConfig(
            Consumer<GetDistributionConfigRequest.Builder> getDistributionConfigRequest) throws NoSuchDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        return getDistributionConfig(GetDistributionConfigRequest.builder().applyMutation(getDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetFieldLevelEncryptionRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionRequest.Builder} to create a
     *        request.
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionResponse getFieldLevelEncryption(
            Consumer<GetFieldLevelEncryptionRequest.Builder> getFieldLevelEncryptionRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        return getFieldLevelEncryption(GetFieldLevelEncryptionRequest.builder().applyMutation(getFieldLevelEncryptionRequest)
                .build());
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            Consumer<GetFieldLevelEncryptionConfigRequest.Builder> getFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionConfig(GetFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link GetFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            Consumer<GetFieldLevelEncryptionProfileRequest.Builder> getFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionProfile(GetFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetFieldLevelEncryptionProfileConfigRequest.Builder} avoiding the need to create one manually via
     * {@link GetFieldLevelEncryptionProfileConfigRequest#builder()}
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetFieldLevelEncryptionProfileConfigRequest.Builder}
     *        to create a request.
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            Consumer<GetFieldLevelEncryptionProfileConfigRequest.Builder> getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getFieldLevelEncryptionProfileConfig(GetFieldLevelEncryptionProfileConfigRequest.builder()
                .applyMutation(getFieldLevelEncryptionProfileConfigRequest).build());
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetInvalidation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvalidationRequest.Builder} avoiding the need
     * to create one manually via {@link GetInvalidationRequest#builder()}
     * </p>
     *
     * @param getInvalidationRequest
     *        A {@link Consumer} that will call methods on {@link GetInvalidationRequest.Builder} to create a request.
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetInvalidation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInvalidationResponse getInvalidation(Consumer<GetInvalidationRequest.Builder> getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return getInvalidation(GetInvalidationRequest.builder().applyMutation(getInvalidationRequest).build());
    }

    /**
     * <p>
     * Get the public key information.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException,
            NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the public key information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPublicKeyRequest#builder()}
     * </p>
     *
     * @param getPublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyRequest.Builder} to create a request.
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPublicKeyResponse getPublicKey(Consumer<GetPublicKeyRequest.Builder> getPublicKeyRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getPublicKey(GetPublicKeyRequest.builder().applyMutation(getPublicKeyRequest).build());
    }

    /**
     * <p>
     * Return public key configuration informaation
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return public key configuration informaation
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPublicKeyConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetPublicKeyConfigRequest#builder()}
     * </p>
     *
     * @param getPublicKeyConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetPublicKeyConfigRequest.Builder} to create a
     *        request.
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default GetPublicKeyConfigResponse getPublicKeyConfig(Consumer<GetPublicKeyConfigRequest.Builder> getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {
        return getPublicKeyConfig(GetPublicKeyConfigRequest.builder().applyMutation(getPublicKeyConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionResponse getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionRequest.Builder} avoiding
     * the need to create one manually via {@link GetStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionRequest.Builder} to create a
     *        request. The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionResponse getStreamingDistribution(
            Consumer<GetStreamingDistributionRequest.Builder> getStreamingDistributionRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getStreamingDistribution(GetStreamingDistributionRequest.builder().applyMutation(getStreamingDistributionRequest)
                .build());
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStreamingDistributionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link GetStreamingDistributionConfigRequest#builder()}
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        A {@link Consumer} that will call methods on {@link GetStreamingDistributionConfigRequest.Builder} to
     *        create a request. To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            Consumer<GetStreamingDistributionConfigRequest.Builder> getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return getStreamingDistributionConfig(GetStreamingDistributionConfigRequest.builder()
                .applyMutation(getStreamingDistributionConfigRequest).build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see #listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder().build());
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder} avoiding the need to create one manually via
     * {@link ListCloudFrontOriginAccessIdentitiesRequest#builder()}
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListCloudFrontOriginAccessIdentitiesRequest.Builder}
     *        to create a request. The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            Consumer<ListCloudFrontOriginAccessIdentitiesRequest.Builder> listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest.builder()
                .applyMutation(listCloudFrontOriginAccessIdentitiesRequest).build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see #listDistributions(ListDistributionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions() throws InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listDistributions(ListDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDistributionsRequest#builder()}
     * </p>
     *
     * @param listDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsRequest.Builder} to create a request.
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDistributionsResponse listDistributions(Consumer<ListDistributionsRequest.Builder> listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listDistributions(ListDistributionsRequest.builder().applyMutation(listDistributionsRequest).build());
    }

    /**
     * <p>
     * List the distributions that are associated with a specified AWS WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified AWS WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException,
            InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the distributions that are associated with a specified AWS WAF web ACL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDistributionsByWebAclIdRequest.Builder}
     * avoiding the need to create one manually via {@link ListDistributionsByWebAclIdRequest#builder()}
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        A {@link Consumer} that will call methods on {@link ListDistributionsByWebACLIdRequest.Builder} to create
     *        a request. The request to list distributions that are associated with a specified AWS WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            Consumer<ListDistributionsByWebAclIdRequest.Builder> listDistributionsByWebAclIdRequest)
            throws InvalidArgumentException, InvalidWebAclIdException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest.builder()
                .applyMutation(listDistributionsByWebAclIdRequest).build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see #listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder().build());
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionConfigsRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionConfigsRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            Consumer<ListFieldLevelEncryptionConfigsRequest.Builder> listFieldLevelEncryptionConfigsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionConfigs(ListFieldLevelEncryptionConfigsRequest.builder()
                .applyMutation(listFieldLevelEncryptionConfigsRequest).build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see #listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles() throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder().build());
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldLevelEncryptionProfilesRequest.Builder}
     * avoiding the need to create one manually via {@link ListFieldLevelEncryptionProfilesRequest#builder()}
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldLevelEncryptionProfilesRequest.Builder} to
     *        create a request.
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            Consumer<ListFieldLevelEncryptionProfilesRequest.Builder> listFieldLevelEncryptionProfilesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listFieldLevelEncryptionProfiles(ListFieldLevelEncryptionProfilesRequest.builder()
                .applyMutation(listFieldLevelEncryptionProfilesRequest).build());
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvalidationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvalidationsRequest#builder()}
     * </p>
     *
     * @param listInvalidationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvalidationsRequest.Builder} to create a request.
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvalidationsResponse listInvalidations(Consumer<ListInvalidationsRequest.Builder> listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listInvalidations(ListInvalidationsRequest.builder().applyMutation(listInvalidationsRequest).build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see #listPublicKeys(ListPublicKeysRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys() throws InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listPublicKeys(ListPublicKeysRequest.builder().build());
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPublicKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListPublicKeysRequest#builder()}
     * </p>
     *
     * @param listPublicKeysRequest
     *        A {@link Consumer} that will call methods on {@link ListPublicKeysRequest.Builder} to create a request.
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPublicKeysResponse listPublicKeys(Consumer<ListPublicKeysRequest.Builder> listPublicKeysRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listPublicKeys(ListPublicKeysRequest.builder().applyMutation(listPublicKeysRequest).build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see #listStreamingDistributions(ListStreamingDistributionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions() throws InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder().build());
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamingDistributionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListStreamingDistributionsRequest#builder()}
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamingDistributionsRequest.Builder} to create a
     *        request. The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStreamingDistributionsResponse listStreamingDistributions(
            Consumer<ListStreamingDistributionsRequest.Builder> listStreamingDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {
        return listStreamingDistributions(ListStreamingDistributionsRequest.builder()
                .applyMutation(listStreamingDistributionsRequest).build());
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request. The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request. The
     *        request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request. The
     *        request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateCloudFrontOriginAccessIdentityRequest#builder()}
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCloudFrontOriginAccessIdentityRequest.Builder}
     *        to create a request. The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            Consumer<UpdateCloudFrontOriginAccessIdentityRequest.Builder> updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest.builder()
                .applyMutation(updateCloudFrontOriginAccessIdentityRequest).build());
    }

    /**
     * <p>
     * Updates the configuration for a web distribution.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using this API action, follow the steps here to get the current configuration and
     * then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     * <p>
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the
     * updates.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console instead, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">
     * GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the
     * distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you must get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include your changes.
     * </p>
     * <important>
     * <p>
     * When you edit the XML file, be aware of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must strip out the ETag parameter that is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * Additional fields are required when you update a distribution. There may be fields included in the XML file for
     * features that you haven't configured for your distribution. This is expected and required to successfully update
     * the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns
     * an <code>IllegalUpdate</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </li>
     * </ul>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * request to confirm that your changes have propagated. When propagation is complete, the value of
     * <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException,
            InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException,
            InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException,
            InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException,
            IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for a web distribution.
     * </p>
     * <important>
     * <p>
     * When you update a distribution, there are more required fields than when you create a distribution. When you
     * update your distribution by using this API action, follow the steps here to get the current configuration and
     * then make your updates, to make sure that you include all of the required fields. To view a summary, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html"
     * >Required Fields for Create Distribution and Update Distribution</a> in the <i>Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * </important>
     * <p>
     * The update process includes getting the current distribution configuration, updating the XML document that is
     * returned to make your changes, and then submitting an <code>UpdateDistribution</code> request to make the
     * updates.
     * </p>
     * <p>
     * For information about updating a distribution using the CloudFront console instead, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html"
     * >Creating a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit a <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html">
     * GetDistributionConfig</a> request to get the current configuration and an <code>Etag</code> header for the
     * distribution.
     * </p>
     * <note>
     * <p>
     * If you update the distribution again, you must get a new <code>Etag</code> header.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GetDistributionConfig</code> request to
     * include your changes.
     * </p>
     * <important>
     * <p>
     * When you edit the XML file, be aware of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must strip out the ETag parameter that is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * Additional fields are required when you update a distribution. There may be fields included in the XML file for
     * features that you haven't configured for your distribution. This is expected and required to successfully update
     * the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>. If you try to change this value, CloudFront returns
     * an <code>IllegalUpdate</code> error.
     * </p>
     * </li>
     * <li>
     * <p>
     * The new configuration replaces the existing configuration; the values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. When you add, delete, or
     * replace values in an element that allows multiple values (for example, <code>CNAME</code>), you must specify all
     * of the values that you want to appear in the updated distribution. In addition, you must update the corresponding
     * <code>Quantity</code> element.
     * </p>
     * </li>
     * </ul>
     * </important></li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request to update the configuration for your distribution:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In the request body, include the XML document that you updated in Step 2. The request body must include an XML
     * document with a <code>DistributionConfig</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set the value of the HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that
     * CloudFront returned when you submitted the <code>GetDistributionConfig</code> request in Step 1.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>UpdateDistribution</code> request to confirm that the configuration was
     * successfully updated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Optional: Submit a <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * request to confirm that your changes have propagated. When propagation is complete, the value of
     * <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDistributionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDistributionRequest#builder()}
     * </p>
     *
     * @param updateDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDistributionRequest.Builder} to create a
     *        request. The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of AWS WAF,
     *         use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda function associations
     *         per owner to be exceeded.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateDistributionResponse updateDistribution(Consumer<UpdateDistributionRequest.Builder> updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException,
            InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidTtlOrderException,
            InvalidWebAclIdException, TooManyOriginCustomHeadersException, TooManyQueryStringParametersException,
            InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException,
            IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {
        return updateDistribution(UpdateDistributionRequest.builder().applyMutation(updateDistributionRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionConfigRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            Consumer<UpdateFieldLevelEncryptionConfigRequest.Builder> updateFieldLevelEncryptionConfigRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException,
            NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateFieldLevelEncryptionConfig(UpdateFieldLevelEncryptionConfigRequest.builder()
                .applyMutation(updateFieldLevelEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException,
            InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldLevelEncryptionProfileRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFieldLevelEncryptionProfileRequest#builder()}
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldLevelEncryptionProfileRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            Consumer<UpdateFieldLevelEncryptionProfileRequest.Builder> updateFieldLevelEncryptionProfileRequest)
            throws AccessDeniedException, FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException,
            InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {
        return updateFieldLevelEncryptionProfile(UpdateFieldLevelEncryptionProfileRequest.builder()
                .applyMutation(updateFieldLevelEncryptionProfileRequest).build());
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException,
            CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException,
            IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException,
            SdkClientException, CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePublicKeyRequest#builder()}
     * </p>
     *
     * @param updatePublicKeyRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePublicKeyRequest.Builder} to create a request.
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdatePublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePublicKeyResponse updatePublicKey(Consumer<UpdatePublicKeyRequest.Builder> updatePublicKeyRequest)
            throws AccessDeniedException, CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException,
            InvalidIfMatchVersionException, IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return updatePublicKey(UpdatePublicKeyRequest.builder().applyMutation(updatePublicKeyRequest).build());
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStreamingDistributionResponse updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException,
            InvalidArgumentException, InvalidOriginAccessIdentityException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InconsistentQuantitiesException, AwsServiceException, SdkClientException,
            CloudFrontException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStreamingDistributionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateStreamingDistributionRequest#builder()}
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStreamingDistributionRequest.Builder} to create
     *        a request. The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         Origin and <code>CallerReference</code> cannot be updated.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid for the distribution.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition given in one or more of the request-header fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         The argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2019-03-26/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStreamingDistributionResponse updateStreamingDistribution(
            Consumer<UpdateStreamingDistributionRequest.Builder> updateStreamingDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchStreamingDistributionException, PreconditionFailedException,
            TooManyStreamingDistributionCnamEsException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {
        return updateStreamingDistribution(UpdateStreamingDistributionRequest.builder()
                .applyMutation(updateStreamingDistributionRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("cloudfront");
    }
}
