/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CertificateSource;
import software.amazon.awssdk.services.cloudfront.model.MinimumProtocolVersion;
import software.amazon.awssdk.services.cloudfront.model.SSLSupportMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewerCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewerCertificate> {
    private static final SdkField<Boolean> CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ViewerCertificate.getter(ViewerCertificate::cloudFrontDefaultCertificate)).setter(ViewerCertificate.setter(Builder::cloudFrontDefaultCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontDefaultCertificate").unmarshallLocationName("CloudFrontDefaultCertificate").build()}).build();
    private static final SdkField<String> IAM_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::iamCertificateId)).setter(ViewerCertificate.setter(Builder::iamCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMCertificateId").unmarshallLocationName("IAMCertificateId").build()}).build();
    private static final SdkField<String> ACM_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::acmCertificateArn)).setter(ViewerCertificate.setter(Builder::acmCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACMCertificateArn").unmarshallLocationName("ACMCertificateArn").build()}).build();
    private static final SdkField<String> SSL_SUPPORT_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::sslSupportMethodAsString)).setter(ViewerCertificate.setter(Builder::sslSupportMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLSupportMethod").unmarshallLocationName("SSLSupportMethod").build()}).build();
    private static final SdkField<String> MINIMUM_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::minimumProtocolVersionAsString)).setter(ViewerCertificate.setter(Builder::minimumProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumProtocolVersion").unmarshallLocationName("MinimumProtocolVersion").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::certificate)).setter(ViewerCertificate.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").unmarshallLocationName("Certificate").build()}).build();
    private static final SdkField<String> CERTIFICATE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ViewerCertificate.getter(ViewerCertificate::certificateSourceAsString)).setter(ViewerCertificate.setter(Builder::certificateSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateSource").unmarshallLocationName("CertificateSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_DEFAULT_CERTIFICATE_FIELD, IAM_CERTIFICATE_ID_FIELD, ACM_CERTIFICATE_ARN_FIELD, SSL_SUPPORT_METHOD_FIELD, MINIMUM_PROTOCOL_VERSION_FIELD, CERTIFICATE_FIELD, CERTIFICATE_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean cloudFrontDefaultCertificate;
    private final String iamCertificateId;
    private final String acmCertificateArn;
    private final String sslSupportMethod;
    private final String minimumProtocolVersion;
    private final String certificate;
    private final String certificateSource;

    private ViewerCertificate(BuilderImpl builder) {
        this.cloudFrontDefaultCertificate = builder.cloudFrontDefaultCertificate;
        this.iamCertificateId = builder.iamCertificateId;
        this.acmCertificateArn = builder.acmCertificateArn;
        this.sslSupportMethod = builder.sslSupportMethod;
        this.minimumProtocolVersion = builder.minimumProtocolVersion;
        this.certificate = builder.certificate;
        this.certificateSource = builder.certificateSource;
    }

    public Boolean cloudFrontDefaultCertificate() {
        return this.cloudFrontDefaultCertificate;
    }

    public String iamCertificateId() {
        return this.iamCertificateId;
    }

    public String acmCertificateArn() {
        return this.acmCertificateArn;
    }

    public SSLSupportMethod sslSupportMethod() {
        return SSLSupportMethod.fromValue(this.sslSupportMethod);
    }

    public String sslSupportMethodAsString() {
        return this.sslSupportMethod;
    }

    public MinimumProtocolVersion minimumProtocolVersion() {
        return MinimumProtocolVersion.fromValue(this.minimumProtocolVersion);
    }

    public String minimumProtocolVersionAsString() {
        return this.minimumProtocolVersion;
    }

    public String certificate() {
        return this.certificate;
    }

    public CertificateSource certificateSource() {
        return CertificateSource.fromValue(this.certificateSource);
    }

    public String certificateSourceAsString() {
        return this.certificateSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontDefaultCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acmCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslSupportMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumProtocolVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateSourceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewerCertificate)) {
            return false;
        }
        ViewerCertificate other = (ViewerCertificate)obj;
        return Objects.equals(this.cloudFrontDefaultCertificate(), other.cloudFrontDefaultCertificate()) && Objects.equals(this.iamCertificateId(), other.iamCertificateId()) && Objects.equals(this.acmCertificateArn(), other.acmCertificateArn()) && Objects.equals(this.sslSupportMethodAsString(), other.sslSupportMethodAsString()) && Objects.equals(this.minimumProtocolVersionAsString(), other.minimumProtocolVersionAsString()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.certificateSourceAsString(), other.certificateSourceAsString());
    }

    public String toString() {
        return ToString.builder((String)"ViewerCertificate").add("CloudFrontDefaultCertificate", (Object)this.cloudFrontDefaultCertificate()).add("IAMCertificateId", (Object)this.iamCertificateId()).add("ACMCertificateArn", (Object)this.acmCertificateArn()).add("SSLSupportMethod", (Object)this.sslSupportMethodAsString()).add("MinimumProtocolVersion", (Object)this.minimumProtocolVersionAsString()).add("Certificate", (Object)this.certificate()).add("CertificateSource", (Object)this.certificateSourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontDefaultCertificate": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontDefaultCertificate()));
            }
            case "IAMCertificateId": {
                return Optional.ofNullable(clazz.cast(this.iamCertificateId()));
            }
            case "ACMCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.acmCertificateArn()));
            }
            case "SSLSupportMethod": {
                return Optional.ofNullable(clazz.cast(this.sslSupportMethodAsString()));
            }
            case "MinimumProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumProtocolVersionAsString()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "CertificateSource": {
                return Optional.ofNullable(clazz.cast(this.certificateSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ViewerCertificate, T> g) {
        return obj -> g.apply((ViewerCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean cloudFrontDefaultCertificate;
        private String iamCertificateId;
        private String acmCertificateArn;
        private String sslSupportMethod;
        private String minimumProtocolVersion;
        private String certificate;
        private String certificateSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewerCertificate model) {
            this.cloudFrontDefaultCertificate(model.cloudFrontDefaultCertificate);
            this.iamCertificateId(model.iamCertificateId);
            this.acmCertificateArn(model.acmCertificateArn);
            this.sslSupportMethod(model.sslSupportMethod);
            this.minimumProtocolVersion(model.minimumProtocolVersion);
            this.certificate(model.certificate);
            this.certificateSource(model.certificateSource);
        }

        public final Boolean getCloudFrontDefaultCertificate() {
            return this.cloudFrontDefaultCertificate;
        }

        @Override
        public final Builder cloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
            return this;
        }

        public final void setCloudFrontDefaultCertificate(Boolean cloudFrontDefaultCertificate) {
            this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
        }

        public final String getIamCertificateId() {
            return this.iamCertificateId;
        }

        @Override
        public final Builder iamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
            return this;
        }

        public final void setIamCertificateId(String iamCertificateId) {
            this.iamCertificateId = iamCertificateId;
        }

        public final String getAcmCertificateArn() {
            return this.acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final void setAcmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        public final String getSslSupportMethodAsString() {
            return this.sslSupportMethod;
        }

        @Override
        public final Builder sslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
            return this;
        }

        @Override
        public final Builder sslSupportMethod(SSLSupportMethod sslSupportMethod) {
            this.sslSupportMethod(sslSupportMethod == null ? null : sslSupportMethod.toString());
            return this;
        }

        public final void setSslSupportMethod(String sslSupportMethod) {
            this.sslSupportMethod = sslSupportMethod;
        }

        public final String getMinimumProtocolVersionAsString() {
            return this.minimumProtocolVersion;
        }

        @Override
        public final Builder minimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
            return this;
        }

        @Override
        public final Builder minimumProtocolVersion(MinimumProtocolVersion minimumProtocolVersion) {
            this.minimumProtocolVersion(minimumProtocolVersion == null ? null : minimumProtocolVersion.toString());
            return this;
        }

        public final void setMinimumProtocolVersion(String minimumProtocolVersion) {
            this.minimumProtocolVersion = minimumProtocolVersion;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getCertificateSourceAsString() {
            return this.certificateSource;
        }

        @Override
        public final Builder certificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
            return this;
        }

        @Override
        public final Builder certificateSource(CertificateSource certificateSource) {
            this.certificateSource(certificateSource == null ? null : certificateSource.toString());
            return this;
        }

        public final void setCertificateSource(String certificateSource) {
            this.certificateSource = certificateSource;
        }

        public ViewerCertificate build() {
            return new ViewerCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewerCertificate> {
        public Builder cloudFrontDefaultCertificate(Boolean var1);

        public Builder iamCertificateId(String var1);

        public Builder acmCertificateArn(String var1);

        public Builder sslSupportMethod(String var1);

        public Builder sslSupportMethod(SSLSupportMethod var1);

        public Builder minimumProtocolVersion(String var1);

        public Builder minimumProtocolVersion(MinimumProtocolVersion var1);

        public Builder certificate(String var1);

        public Builder certificateSource(String var1);

        public Builder certificateSource(CertificateSource var1);
    }
}

