/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFrontOriginAccessIdentityConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentityConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudFrontOriginAccessIdentityConfig.getter(CloudFrontOriginAccessIdentityConfig::callerReference)).setter(CloudFrontOriginAccessIdentityConfig.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CloudFrontOriginAccessIdentityConfig.getter(CloudFrontOriginAccessIdentityConfig::comment)).setter(CloudFrontOriginAccessIdentityConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD, COMMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String callerReference;
    private final String comment;

    private CloudFrontOriginAccessIdentityConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.comment = builder.comment;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentityConfig)) {
            return false;
        }
        CloudFrontOriginAccessIdentityConfig other = (CloudFrontOriginAccessIdentityConfig)obj;
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.comment(), other.comment());
    }

    public String toString() {
        return ToString.builder((String)"CloudFrontOriginAccessIdentityConfig").add("CallerReference", (Object)this.callerReference()).add("Comment", (Object)this.comment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFrontOriginAccessIdentityConfig, T> g) {
        return obj -> g.apply((CloudFrontOriginAccessIdentityConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentityConfig model) {
            this.callerReference(model.callerReference);
            this.comment(model.comment);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public CloudFrontOriginAccessIdentityConfig build() {
            return new CloudFrontOriginAccessIdentityConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFrontOriginAccessIdentityConfig> {
        public Builder callerReference(String var1);

        public Builder comment(String var1);
    }
}

