/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetDistributionResponse.Builder, GetDistributionResponse> {
    private static final SdkField<Distribution> DISTRIBUTION_FIELD = SdkField
            .<Distribution> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDistributionResponse::distribution))
            .setter(setter(Builder::distribution))
            .constructor(Distribution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distribution")
                    .unmarshallLocationName("Distribution").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetDistributionResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_FIELD,
            E_TAG_FIELD));

    private final Distribution distribution;

    private final String eTag;

    private GetDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.distribution = builder.distribution;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's information.
     * </p>
     * 
     * @return The distribution's information.
     */
    public Distribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(distribution());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionResponse)) {
            return false;
        }
        GetDistributionResponse other = (GetDistributionResponse) obj;
        return Objects.equals(distribution(), other.distribution()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDistributionResponse").add("Distribution", distribution()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distribution":
            return Optional.ofNullable(clazz.cast(distribution()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionResponse, T> g) {
        return obj -> g.apply((GetDistributionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDistributionResponse> {
        /**
         * <p>
         * The distribution's information.
         * </p>
         * 
         * @param distribution
         *        The distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link Distribution.Builder} avoiding the need to
         * create one manually via {@link Distribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link Distribution.Builder#build()} is called immediately and its
         * result is passed to {@link #distribution(Distribution)}.
         * 
         * @param distribution
         *        a consumer that will call methods on {@link Distribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distribution(Distribution)
         */
        default Builder distribution(Consumer<Distribution.Builder> distribution) {
            return distribution(Distribution.builder().applyMutation(distribution).build());
        }

        /**
         * <p>
         * The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the distribution's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private Distribution distribution;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionResponse model) {
            super(model);
            distribution(model.distribution);
            eTag(model.eTag);
        }

        public final Distribution.Builder getDistribution() {
            return distribution != null ? distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetDistributionResponse build() {
            return new GetDistributionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
