/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudFrontOriginAccessIdentityResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetCloudFrontOriginAccessIdentityResponse.Builder, GetCloudFrontOriginAccessIdentityResponse> {
    private static final SdkField<CloudFrontOriginAccessIdentity> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD = SdkField
            .<CloudFrontOriginAccessIdentity> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetCloudFrontOriginAccessIdentityResponse::cloudFrontOriginAccessIdentity))
            .setter(setter(Builder::cloudFrontOriginAccessIdentity))
            .constructor(CloudFrontOriginAccessIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentity")
                    .unmarshallLocationName("CloudFrontOriginAccessIdentity").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetCloudFrontOriginAccessIdentityResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_FIELD, E_TAG_FIELD));

    private final CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;

    private final String eTag;

    private GetCloudFrontOriginAccessIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentity = builder.cloudFrontOriginAccessIdentity;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The origin access identity's information.
     * </p>
     * 
     * @return The origin access identity's information.
     */
    public CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity() {
        return cloudFrontOriginAccessIdentity;
    }

    /**
     * <p>
     * The current version of the origin access identity's information. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the origin access identity's information. For example: <code>E2QWRUHAPOMQZL</code>
     *         .
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudFrontOriginAccessIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudFrontOriginAccessIdentityResponse)) {
            return false;
        }
        GetCloudFrontOriginAccessIdentityResponse other = (GetCloudFrontOriginAccessIdentityResponse) obj;
        return Objects.equals(cloudFrontOriginAccessIdentity(), other.cloudFrontOriginAccessIdentity())
                && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCloudFrontOriginAccessIdentityResponse")
                .add("CloudFrontOriginAccessIdentity", cloudFrontOriginAccessIdentity()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentity":
            return Optional.ofNullable(clazz.cast(cloudFrontOriginAccessIdentity()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCloudFrontOriginAccessIdentityResponse, T> g) {
        return obj -> g.apply((GetCloudFrontOriginAccessIdentityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCloudFrontOriginAccessIdentityResponse> {
        /**
         * <p>
         * The origin access identity's information.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentity
         *        The origin access identity's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity);

        /**
         * <p>
         * The origin access identity's information.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudFrontOriginAccessIdentity.Builder} avoiding
         * the need to create one manually via {@link CloudFrontOriginAccessIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFrontOriginAccessIdentity.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity)}.
         * 
         * @param cloudFrontOriginAccessIdentity
         *        a consumer that will call methods on {@link CloudFrontOriginAccessIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity)
         */
        default Builder cloudFrontOriginAccessIdentity(
                Consumer<CloudFrontOriginAccessIdentity.Builder> cloudFrontOriginAccessIdentity) {
            return cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity.builder()
                    .applyMutation(cloudFrontOriginAccessIdentity).build());
        }

        /**
         * <p>
         * The current version of the origin access identity's information. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the origin access identity's information. For example:
         *        <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudFrontOriginAccessIdentityResponse model) {
            super(model);
            cloudFrontOriginAccessIdentity(model.cloudFrontOriginAccessIdentity);
            eTag(model.eTag);
        }

        public final CloudFrontOriginAccessIdentity.Builder getCloudFrontOriginAccessIdentity() {
            return cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentity(CloudFrontOriginAccessIdentity cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentity(
                CloudFrontOriginAccessIdentity.BuilderImpl cloudFrontOriginAccessIdentity) {
            this.cloudFrontOriginAccessIdentity = cloudFrontOriginAccessIdentity != null ? cloudFrontOriginAccessIdentity.build()
                    : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public GetCloudFrontOriginAccessIdentityResponse build() {
            return new GetCloudFrontOriginAccessIdentityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
