/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RTMP distribution's configuration information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistributionConfig implements
        ToCopyableBuilder<StreamingDistributionConfig.Builder, StreamingDistributionConfig> {
    private final String callerReference;

    private final S3Origin s3Origin;

    private final Aliases aliases;

    private final String comment;

    private final StreamingLoggingConfig logging;

    private final TrustedSigners trustedSigners;

    private final String priceClass;

    private final Boolean enabled;

    private StreamingDistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.s3Origin = builder.s3Origin;
        this.aliases = builder.aliases;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.trustedSigners = builder.trustedSigners;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is new (no
     * matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming distribution is
     * created. If the <code>CallerReference</code> is a value that you already sent in a previous request to create a
     * streaming distribution, and the content of the <code>StreamingDistributionConfig</code> is identical to the
     * original request (ignoring white space), the response includes the same information returned to the original
     * request. If the <code>CallerReference</code> is a value that you already sent in a previous request to create a
     * streaming distribution but the content of the <code>StreamingDistributionConfig</code> is different from the
     * original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is
     *         new (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming
     *         distribution is created. If the <code>CallerReference</code> is a value that you already sent in a
     *         previous request to create a streaming distribution, and the content of the
     *         <code>StreamingDistributionConfig</code> is identical to the original request (ignoring white space), the
     *         response includes the same information returned to the original request. If the
     *         <code>CallerReference</code> is a value that you already sent in a previous request to create a streaming
     *         distribution but the content of the <code>StreamingDistributionConfig</code> is different from the
     *         original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your
     * media files for distribution.
     * </p>
     * 
     * @return A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
     *         your media files for distribution.
     */
    public S3Origin s3Origin() {
        return s3Origin;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
     * distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         streaming distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * Any comments you want to include about the streaming distribution.
     * </p>
     * 
     * @return Any comments you want to include about the streaming distribution.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the streaming distribution.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the streaming distribution.
     */
    public StreamingLoggingConfig logging() {
        return logging;
    }

    /**
     * <p>
     * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private content.
     * If you want the distribution to use signed URLs, include this element; if you want the distribution to use public
     * URLs, remove this element. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
     *         content. If you want the distribution to use signed URLs, include this element; if you want the
     *         distribution to use public URLs, remove this element. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public TrustedSigners trustedSigners() {
        return trustedSigners;
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * A complex type that contains information about price class for this streaming distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassString}.
     * </p>
     * 
     * @return A complex type that contains information about price class for this streaming distribution.
     * @see PriceClass
     */
    public String priceClassString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the streaming distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the streaming distribution is enabled to accept user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(s3Origin());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(trustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionConfig)) {
            return false;
        }
        StreamingDistributionConfig other = (StreamingDistributionConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(s3Origin(), other.s3Origin())
                && Objects.equals(aliases(), other.aliases()) && Objects.equals(comment(), other.comment())
                && Objects.equals(logging(), other.logging()) && Objects.equals(trustedSigners(), other.trustedSigners())
                && Objects.equals(priceClassString(), other.priceClassString()) && Objects.equals(enabled(), other.enabled());
    }

    @Override
    public String toString() {
        return ToString.builder("StreamingDistributionConfig").add("CallerReference", callerReference())
                .add("S3Origin", s3Origin()).add("Aliases", aliases()).add("Comment", comment()).add("Logging", logging())
                .add("TrustedSigners", trustedSigners()).add("PriceClass", priceClassString()).add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.of(clazz.cast(callerReference()));
        case "S3Origin":
            return Optional.of(clazz.cast(s3Origin()));
        case "Aliases":
            return Optional.of(clazz.cast(aliases()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "Logging":
            return Optional.of(clazz.cast(logging()));
        case "TrustedSigners":
            return Optional.of(clazz.cast(trustedSigners()));
        case "PriceClass":
            return Optional.of(clazz.cast(priceClassString()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionConfig> {
        /**
         * <p>
         * A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code> is new
         * (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming distribution
         * is created. If the <code>CallerReference</code> is a value that you already sent in a previous request to
         * create a streaming distribution, and the content of the <code>StreamingDistributionConfig</code> is identical
         * to the original request (ignoring white space), the response includes the same information returned to the
         * original request. If the <code>CallerReference</code> is a value that you already sent in a previous request
         * to create a streaming distribution but the content of the <code>StreamingDistributionConfig</code> is
         * different from the original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique number that ensures that the request can't be replayed. If the <code>CallerReference</code>
         *        is new (no matter the content of the <code>StreamingDistributionConfig</code> object), a new streaming
         *        distribution is created. If the <code>CallerReference</code> is a value that you already sent in a
         *        previous request to create a streaming distribution, and the content of the
         *        <code>StreamingDistributionConfig</code> is identical to the original request (ignoring white space),
         *        the response includes the same information returned to the original request. If the
         *        <code>CallerReference</code> is a value that you already sent in a previous request to create a
         *        streaming distribution but the content of the <code>StreamingDistributionConfig</code> is different
         *        from the original request, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * 
         * @param s3Origin
         *        A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to
         *        get your media files for distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Origin(S3Origin s3Origin);

        /**
         * <p>
         * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get
         * your media files for distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Origin.Builder} avoiding the need to create
         * one manually via {@link S3Origin#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Origin.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Origin(S3Origin)}.
         * 
         * @param s3Origin
         *        a consumer that will call methods on {@link S3Origin.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Origin(S3Origin)
         */
        default Builder s3Origin(Consumer<S3Origin.Builder> s3Origin) {
            return s3Origin(S3Origin.builder().apply(s3Origin).build());
        }

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this streaming
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().apply(aliases).build());
        }

        /**
         * <p>
         * Any comments you want to include about the streaming distribution.
         * </p>
         * 
         * @param comment
         *        Any comments you want to include about the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the streaming distribution.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the streaming distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(StreamingLoggingConfig logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the streaming distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingLoggingConfig.Builder} avoiding the
         * need to create one manually via {@link StreamingLoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingLoggingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #logging(StreamingLoggingConfig)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link StreamingLoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(StreamingLoggingConfig)
         */
        default Builder logging(Consumer<StreamingLoggingConfig.Builder> logging) {
            return logging(StreamingLoggingConfig.builder().apply(logging).build());
        }

        /**
         * <p>
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
         * content. If you want the distribution to use signed URLs, include this element; if you want the distribution
         * to use public URLs, remove this element. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param trustedSigners
         *        A complex type that specifies any AWS accounts that you want to permit to create signed URLs for
         *        private content. If you want the distribution to use signed URLs, include this element; if you want
         *        the distribution to use public URLs, remove this element. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedSigners(TrustedSigners trustedSigners);

        /**
         * <p>
         * A complex type that specifies any AWS accounts that you want to permit to create signed URLs for private
         * content. If you want the distribution to use signed URLs, include this element; if you want the distribution
         * to use public URLs, remove this element. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link TrustedSigners.Builder} avoiding the need to
         * create one manually via {@link TrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrustedSigners.Builder#build()} is called immediately and its
         * result is passed to {@link #trustedSigners(TrustedSigners)}.
         * 
         * @param trustedSigners
         *        a consumer that will call methods on {@link TrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedSigners(TrustedSigners)
         */
        default Builder trustedSigners(Consumer<TrustedSigners.Builder> trustedSigners) {
            return trustedSigners(TrustedSigners.builder().apply(trustedSigners).build());
        }

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * A complex type that contains information about price class for this streaming distribution.
         * </p>
         * 
         * @param priceClass
         *        A complex type that contains information about price class for this streaming distribution.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the streaming distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the streaming distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private S3Origin s3Origin;

        private Aliases aliases;

        private String comment;

        private StreamingLoggingConfig logging;

        private TrustedSigners trustedSigners;

        private String priceClass;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionConfig model) {
            callerReference(model.callerReference);
            s3Origin(model.s3Origin);
            aliases(model.aliases);
            comment(model.comment);
            logging(model.logging);
            trustedSigners(model.trustedSigners);
            priceClass(model.priceClass);
            enabled(model.enabled);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final S3Origin.Builder getS3Origin() {
            return s3Origin != null ? s3Origin.toBuilder() : null;
        }

        @Override
        public final Builder s3Origin(S3Origin s3Origin) {
            this.s3Origin = s3Origin;
            return this;
        }

        public final void setS3Origin(S3Origin.BuilderImpl s3Origin) {
            this.s3Origin = s3Origin != null ? s3Origin.build() : null;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final StreamingLoggingConfig.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(StreamingLoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(StreamingLoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public final TrustedSigners.Builder getTrustedSigners() {
            return trustedSigners != null ? trustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder trustedSigners(TrustedSigners trustedSigners) {
            this.trustedSigners = trustedSigners;
            return this;
        }

        public final void setTrustedSigners(TrustedSigners.BuilderImpl trustedSigners) {
            this.trustedSigners = trustedSigners != null ? trustedSigners.build() : null;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public StreamingDistributionConfig build() {
            return new StreamingDistributionConfig(this);
        }
    }
}
