/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains <code>HeaderName</code> and <code>HeaderValue</code> elements, if any, for this
 * distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OriginCustomHeader implements ToCopyableBuilder<OriginCustomHeader.Builder, OriginCustomHeader> {
    private final String headerName;

    private final String headerValue;

    private OriginCustomHeader(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    /**
     * <p>
     * The name of a header that you want CloudFront to forward to your origin. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">Forwarding
     * Custom Headers to Your Origin (Web Distributions Only)</a> in the <i>Amazon Amazon CloudFront Developer
     * Guide</i>.
     * </p>
     * 
     * @return The name of a header that you want CloudFront to forward to your origin. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">
     *         Forwarding Custom Headers to Your Origin (Web Distributions Only)</a> in the <i>Amazon Amazon CloudFront
     *         Developer Guide</i>.
     */
    public String headerName() {
        return headerName;
    }

    /**
     * <p>
     * The value for the header that you specified in the <code>HeaderName</code> field.
     * </p>
     * 
     * @return The value for the header that you specified in the <code>HeaderName</code> field.
     */
    public String headerValue() {
        return headerValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(headerName());
        hashCode = 31 * hashCode + Objects.hashCode(headerValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginCustomHeader)) {
            return false;
        }
        OriginCustomHeader other = (OriginCustomHeader) obj;
        return Objects.equals(headerName(), other.headerName()) && Objects.equals(headerValue(), other.headerValue());
    }

    @Override
    public String toString() {
        return ToString.builder("OriginCustomHeader").add("HeaderName", headerName()).add("HeaderValue", headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderName":
            return Optional.of(clazz.cast(headerName()));
        case "HeaderValue":
            return Optional.of(clazz.cast(headerValue()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, OriginCustomHeader> {
        /**
         * <p>
         * The name of a header that you want CloudFront to forward to your origin. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html"
         * >Forwarding Custom Headers to Your Origin (Web Distributions Only)</a> in the <i>Amazon Amazon CloudFront
         * Developer Guide</i>.
         * </p>
         * 
         * @param headerName
         *        The name of a header that you want CloudFront to forward to your origin. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/forward-custom-headers.html">
         *        Forwarding Custom Headers to Your Origin (Web Distributions Only)</a> in the <i>Amazon Amazon
         *        CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerName(String headerName);

        /**
         * <p>
         * The value for the header that you specified in the <code>HeaderName</code> field.
         * </p>
         * 
         * @param headerValue
         *        The value for the header that you specified in the <code>HeaderName</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValue(String headerValue);
    }

    static final class BuilderImpl implements Builder {
        private String headerName;

        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginCustomHeader model) {
            headerName(model.headerName);
            headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        @Override
        public OriginCustomHeader build() {
            return new OriginCustomHeader(this);
        }
    }
}
