/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the active CloudFront key pairs, if any, that are associated with
 * <code>AwsAccountNumber</code>.
 * </p>
 * <p>
 * For more information, see <a>ActiveTrustedSigners</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyPairIds implements ToCopyableBuilder<KeyPairIds.Builder, KeyPairIds> {
    private final Integer quantity;

    private final List<String> items;

    private KeyPairIds(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of active CloudFront key pairs for <code>AwsAccountNumber</code>.
     * </p>
     * <p>
     * For more information, see <a>ActiveTrustedSigners</a>.
     * </p>
     * 
     * @return The number of active CloudFront key pairs for <code>AwsAccountNumber</code>.</p>
     *         <p>
     *         For more information, see <a>ActiveTrustedSigners</a>.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that lists the active CloudFront key pairs, if any, that are associated with
     * <code>AwsAccountNumber</code>.
     * </p>
     * <p>
     * For more information, see <a>ActiveTrustedSigners</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that lists the active CloudFront key pairs, if any, that are associated with
     *         <code>AwsAccountNumber</code>.</p>
     *         <p>
     *         For more information, see <a>ActiveTrustedSigners</a>.
     */
    public List<String> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairIds)) {
            return false;
        }
        KeyPairIds other = (KeyPairIds) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("KeyPairIds").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, KeyPairIds> {
        /**
         * <p>
         * The number of active CloudFront key pairs for <code>AwsAccountNumber</code>.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param quantity
         *        The number of active CloudFront key pairs for <code>AwsAccountNumber</code>.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param items
         *        A complex type that lists the active CloudFront key pairs, if any, that are associated with
         *        <code>AwsAccountNumber</code>.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * <p>
         * For more information, see <a>ActiveTrustedSigners</a>.
         * </p>
         * 
         * @param items
         *        A complex type that lists the active CloudFront key pairs, if any, that are associated with
         *        <code>AwsAccountNumber</code>.</p>
         *        <p>
         *        For more information, see <a>ActiveTrustedSigners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(String... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<String> items;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairIds model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = KeyPairIdListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = KeyPairIdListCopier.copy(items);
        }

        @Override
        public KeyPairIds build() {
            return new KeyPairIds(this);
        }
    }
}
