/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An invalidation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Invalidation implements ToCopyableBuilder<Invalidation.Builder, Invalidation> {
    private final String id;

    private final String status;

    private final Instant createTime;

    private final InvalidationBatch invalidationBatch;

    private Invalidation(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.invalidationBatch = builder.invalidationBatch;
    }

    /**
     * <p>
     * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The status of the invalidation request. When the invalidation batch is finished, the status is
     * <code>Completed</code>.
     * </p>
     * 
     * @return The status of the invalidation request. When the invalidation batch is finished, the status is
     *         <code>Completed</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the invalidation request was first made.
     * </p>
     * 
     * @return The date and time the invalidation request was first made.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The current invalidation information for the batch request.
     * </p>
     * 
     * @return The current invalidation information for the batch request.
     */
    public InvalidationBatch invalidationBatch() {
        return invalidationBatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(invalidationBatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invalidation)) {
            return false;
        }
        Invalidation other = (Invalidation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(status(), other.status())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(invalidationBatch(), other.invalidationBatch());
    }

    @Override
    public String toString() {
        return ToString.builder("Invalidation").add("Id", id()).add("Status", status()).add("CreateTime", createTime())
                .add("InvalidationBatch", invalidationBatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "CreateTime":
            return Optional.of(clazz.cast(createTime()));
        case "InvalidationBatch":
            return Optional.of(clazz.cast(invalidationBatch()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Invalidation> {
        /**
         * <p>
         * The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the invalidation request. For example: <code>IDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the invalidation request. When the invalidation batch is finished, the status is
         * <code>Completed</code>.
         * </p>
         * 
         * @param status
         *        The status of the invalidation request. When the invalidation batch is finished, the status is
         *        <code>Completed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the invalidation request was first made.
         * </p>
         * 
         * @param createTime
         *        The date and time the invalidation request was first made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The current invalidation information for the batch request.
         * </p>
         * 
         * @param invalidationBatch
         *        The current invalidation information for the batch request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidationBatch(InvalidationBatch invalidationBatch);

        /**
         * <p>
         * The current invalidation information for the batch request.
         * </p>
         * This is a convenience that creates an instance of the {@link InvalidationBatch.Builder} avoiding the need to
         * create one manually via {@link InvalidationBatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link InvalidationBatch.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidationBatch(InvalidationBatch)}.
         * 
         * @param invalidationBatch
         *        a consumer that will call methods on {@link InvalidationBatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidationBatch(InvalidationBatch)
         */
        default Builder invalidationBatch(Consumer<InvalidationBatch.Builder> invalidationBatch) {
            return invalidationBatch(InvalidationBatch.builder().apply(invalidationBatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant createTime;

        private InvalidationBatch invalidationBatch;

        private BuilderImpl() {
        }

        private BuilderImpl(Invalidation model) {
            id(model.id);
            status(model.status);
            createTime(model.createTime);
            invalidationBatch(model.invalidationBatch);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final InvalidationBatch.Builder getInvalidationBatch() {
            return invalidationBatch != null ? invalidationBatch.toBuilder() : null;
        }

        @Override
        public final Builder invalidationBatch(InvalidationBatch invalidationBatch) {
            this.invalidationBatch = invalidationBatch;
            return this;
        }

        public final void setInvalidationBatch(InvalidationBatch.BuilderImpl invalidationBatch) {
            this.invalidationBatch = invalidationBatch != null ? invalidationBatch.build() : null;
        }

        @Override
        public Invalidation build() {
            return new Invalidation(this);
        }
    }
}
