/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the list of Custom Headers for each origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomHeaders implements ToCopyableBuilder<CustomHeaders.Builder, CustomHeaders> {
    private final Integer quantity;

    private final List<OriginCustomHeader> items;

    private CustomHeaders(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of custom headers, if any, for this distribution.
     * </p>
     * 
     * @return The number of custom headers, if any, for this distribution.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that you
     * want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header
     *         that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>
     *         .
     */
    public List<OriginCustomHeader> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomHeaders)) {
            return false;
        }
        CustomHeaders other = (CustomHeaders) obj;
        return Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        return ToString.builder("CustomHeaders").add("Quantity", quantity()).add("Items", items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CustomHeaders> {
        /**
         * <p>
         * The number of custom headers, if any, for this distribution.
         * </p>
         * 
         * @param quantity
         *        The number of custom headers, if any, for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that
         * you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom
         *        header that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit
         *        <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<OriginCustomHeader> items);

        /**
         * <p>
         * <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom header that
         * you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        <b>Optional</b>: A list that contains one <code>OriginCustomHeader</code> element for each custom
         *        header that you want CloudFront to forward to the origin. If Quantity is <code>0</code>, omit
         *        <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(OriginCustomHeader... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<OriginCustomHeader> items;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomHeaders model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<OriginCustomHeader.Builder> getItems() {
            return items != null ? items.stream().map(OriginCustomHeader::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<OriginCustomHeader> items) {
            this.items = OriginCustomHeadersListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OriginCustomHeader... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<OriginCustomHeader.BuilderImpl> items) {
            this.items = OriginCustomHeadersListCopier.copyFromBuilder(items);
        }

        @Override
        public CustomHeaders build() {
            return new CustomHeaders(this);
        }
    }
}
