/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingDistributionWithTagsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<CreateStreamingDistributionWithTagsResponse.Builder, CreateStreamingDistributionWithTagsResponse> {
    private final StreamingDistribution streamingDistribution;

    private final String location;

    private final String eTag;

    private CreateStreamingDistributionWithTagsResponse(BuilderImpl builder) {
        super(builder);
        this.streamingDistribution = builder.streamingDistribution;
        this.location = builder.location;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The streaming distribution's information.
     * </p>
     * 
     * @return The streaming distribution's information.
     */
    public StreamingDistribution streamingDistribution() {
        return streamingDistribution;
    }

    /**
     * <p>
     * The fully qualified URI of the new streaming distribution resource just created. For example:
     * <code> https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     * </p>
     * 
     * @return The fully qualified URI of the new streaming distribution resource just created. For example:
     *         <code> https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
     */
    public String location() {
        return location;
    }

    /**
     * Returns the value of the ETag property for this object.
     * 
     * @return The value of the ETag property for this object.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistribution());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionWithTagsResponse)) {
            return false;
        }
        CreateStreamingDistributionWithTagsResponse other = (CreateStreamingDistributionWithTagsResponse) obj;
        return Objects.equals(streamingDistribution(), other.streamingDistribution())
                && Objects.equals(location(), other.location()) && Objects.equals(eTag(), other.eTag());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamingDistributionWithTagsResponse")
                .add("StreamingDistribution", streamingDistribution()).add("Location", location()).add("ETag", eTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistribution":
            return Optional.of(clazz.cast(streamingDistribution()));
        case "Location":
            return Optional.of(clazz.cast(location()));
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontResponse.Builder,
            CopyableBuilder<Builder, CreateStreamingDistributionWithTagsResponse> {
        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * 
         * @param streamingDistribution
         *        The streaming distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistribution(StreamingDistribution streamingDistribution);

        /**
         * <p>
         * The streaming distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistribution.Builder} avoiding the need
         * to create one manually via {@link StreamingDistribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistribution.Builder#build()} is called immediately and
         * its result is passed to {@link #streamingDistribution(StreamingDistribution)}.
         * 
         * @param streamingDistribution
         *        a consumer that will call methods on {@link StreamingDistribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistribution(StreamingDistribution)
         */
        default Builder streamingDistribution(Consumer<StreamingDistribution.Builder> streamingDistribution) {
            return streamingDistribution(StreamingDistribution.builder().apply(streamingDistribution).build());
        }

        /**
         * <p>
         * The fully qualified URI of the new streaming distribution resource just created. For example:
         * <code> https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * </p>
         * 
         * @param location
         *        The fully qualified URI of the new streaming distribution resource just created. For example:
         *        <code> https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * Sets the value of the ETag property for this object.
         *
         * @param eTag
         *        The new value for the ETag property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private StreamingDistribution streamingDistribution;

        private String location;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionWithTagsResponse model) {
            streamingDistribution(model.streamingDistribution);
            location(model.location);
            eTag(model.eTag);
        }

        public final StreamingDistribution.Builder getStreamingDistribution() {
            return streamingDistribution != null ? streamingDistribution.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistribution(StreamingDistribution streamingDistribution) {
            this.streamingDistribution = streamingDistribution;
            return this;
        }

        public final void setStreamingDistribution(StreamingDistribution.BuilderImpl streamingDistribution) {
            this.streamingDistribution = streamingDistribution != null ? streamingDistribution.build() : null;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public CreateStreamingDistributionWithTagsResponse build() {
            return new CreateStreamingDistributionWithTagsResponse(this);
        }
    }
}
