/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new streaming distribution with tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStreamingDistributionWithTagsRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateStreamingDistributionWithTagsRequest.Builder, CreateStreamingDistributionWithTagsRequest> {
    private final StreamingDistributionConfigWithTags streamingDistributionConfigWithTags;

    private CreateStreamingDistributionWithTagsRequest(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionConfigWithTags = builder.streamingDistributionConfigWithTags;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfigWithTags streamingDistributionConfigWithTags() {
        return streamingDistributionConfigWithTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfigWithTags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamingDistributionWithTagsRequest)) {
            return false;
        }
        CreateStreamingDistributionWithTagsRequest other = (CreateStreamingDistributionWithTagsRequest) obj;
        return Objects.equals(streamingDistributionConfigWithTags(), other.streamingDistributionConfigWithTags());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateStreamingDistributionWithTagsRequest")
                .add("StreamingDistributionConfigWithTags", streamingDistributionConfigWithTags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionConfigWithTags":
            return Optional.of(clazz.cast(streamingDistributionConfigWithTags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder,
            CopyableBuilder<Builder, CreateStreamingDistributionWithTagsRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfigWithTags
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfigWithTags(StreamingDistributionConfigWithTags streamingDistributionConfigWithTags);

        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionConfigWithTags.Builder}
         * avoiding the need to create one manually via {@link StreamingDistributionConfigWithTags#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionConfigWithTags.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #streamingDistributionConfigWithTags(StreamingDistributionConfigWithTags)}.
         * 
         * @param streamingDistributionConfigWithTags
         *        a consumer that will call methods on {@link StreamingDistributionConfigWithTags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfigWithTags(StreamingDistributionConfigWithTags)
         */
        default Builder streamingDistributionConfigWithTags(
                Consumer<StreamingDistributionConfigWithTags.Builder> streamingDistributionConfigWithTags) {
            return streamingDistributionConfigWithTags(StreamingDistributionConfigWithTags.builder()
                    .apply(streamingDistributionConfigWithTags).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private StreamingDistributionConfigWithTags streamingDistributionConfigWithTags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamingDistributionWithTagsRequest model) {
            streamingDistributionConfigWithTags(model.streamingDistributionConfigWithTags);
        }

        public final StreamingDistributionConfigWithTags.Builder getStreamingDistributionConfigWithTags() {
            return streamingDistributionConfigWithTags != null ? streamingDistributionConfigWithTags.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfigWithTags(
                StreamingDistributionConfigWithTags streamingDistributionConfigWithTags) {
            this.streamingDistributionConfigWithTags = streamingDistributionConfigWithTags;
            return this;
        }

        public final void setStreamingDistributionConfigWithTags(
                StreamingDistributionConfigWithTags.BuilderImpl streamingDistributionConfigWithTags) {
            this.streamingDistributionConfigWithTags = streamingDistributionConfigWithTags != null ? streamingDistributionConfigWithTags
                    .build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamingDistributionWithTagsRequest build() {
            return new CreateStreamingDistributionWithTagsRequest(this);
        }
    }
}
