/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

/**
 * DeleteServiceLinkedRoleRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteServiceLinkedRoleRequestMarshaller implements
        Marshaller<Request<DeleteServiceLinkedRoleRequest>, DeleteServiceLinkedRoleRequest> {

    public Request<DeleteServiceLinkedRoleRequest> marshall(DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest) {

        if (deleteServiceLinkedRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteServiceLinkedRoleRequest> request = new DefaultRequest<DeleteServiceLinkedRoleRequest>(
                deleteServiceLinkedRoleRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.DELETE);

        String uriResourcePath = "/2017-03-25/service-linked-role/{RoleName}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "RoleName", deleteServiceLinkedRoleRequest.roleName());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}