/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CacheBehaviors StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CacheBehaviorsUnmarshaller implements Unmarshaller<CacheBehaviors, StaxUnmarshallerContext> {

    public CacheBehaviors unmarshall(StaxUnmarshallerContext context) throws Exception {
        CacheBehaviors.Builder cacheBehaviors = CacheBehaviors.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CacheBehavior> items = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cacheBehaviors.items(items);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Quantity", targetDepth)) {
                    cacheBehaviors.quantity(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Items", targetDepth)) {
                    items = new ArrayList<CacheBehavior>();
                    continue;
                }

                if (context.testExpression("Items/CacheBehavior", targetDepth)) {
                    items.add(CacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cacheBehaviors.items(items);
                    break;
                }
            }
        }
        return cacheBehaviors.build();
    }

    private static final CacheBehaviorsUnmarshaller INSTANCE = new CacheBehaviorsUnmarshaller();

    public static CacheBehaviorsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
