/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update a streaming distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateStreamingDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateStreamingDistributionRequest.Builder, UpdateStreamingDistributionRequest> {
    private final StreamingDistributionConfig streamingDistributionConfig;

    private final String id;

    private final String ifMatch;

    private UpdateStreamingDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The streaming distribution's configuration information.
     * </p>
     * 
     * @return The streaming distribution's configuration information.
     */
    public StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    /**
     * <p>
     * The streaming distribution's id.
     * </p>
     * 
     * @return The streaming distribution's id.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
     *         configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamingDistributionRequest)) {
            return false;
        }
        UpdateStreamingDistributionRequest other = (UpdateStreamingDistributionRequest) obj;
        return Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig())
                && Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (streamingDistributionConfig() != null) {
            sb.append("StreamingDistributionConfig: ").append(streamingDistributionConfig()).append(",");
        }
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingDistributionConfig":
            return Optional.of(clazz.cast(streamingDistributionConfig()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "IfMatch":
            return Optional.of(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, UpdateStreamingDistributionRequest> {
        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The streaming distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The streaming distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link StreamingDistributionConfig.Builder} avoiding
         * the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().apply(streamingDistributionConfig).build());
        }

        /**
         * <p>
         * The streaming distribution's id.
         * </p>
         * 
         * @param id
         *        The streaming distribution's id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header that you received when retrieving the streaming distribution's
         * configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header that you received when retrieving the streaming
         *        distribution's configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private StreamingDistributionConfig streamingDistributionConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamingDistributionRequest model) {
            streamingDistributionConfig(model.streamingDistributionConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamingDistributionRequest build() {
            return new UpdateStreamingDistributionRequest(this);
        }
    }
}
