/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains <code>Tag</code> key and <code>Tag</code> value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Tag implements ToCopyableBuilder<Tag.Builder, Tag> {
    private final String key;

    private final String value;

    private Tag(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * A string that contains <code>Tag</code> key.
     * </p>
     * <p>
     * The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>,
     * <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
     * </p>
     * 
     * @return A string that contains <code>Tag</code> key.</p>
     *         <p>
     *         The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>,
     *         <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * A string that contains an optional <code>Tag</code> value.
     * </p>
     * <p>
     * The string length should be between 0 and 256 characters. Valid characters include <code>a-z</code>,
     * <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
     * </p>
     * 
     * @return A string that contains an optional <code>Tag</code> value.</p>
     *         <p>
     *         The string length should be between 0 and 256 characters. Valid characters include <code>a-z</code>,
     *         <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.of(clazz.cast(key()));
        case "Value":
            return Optional.of(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * A string that contains <code>Tag</code> key.
         * </p>
         * <p>
         * The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>,
         * <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
         * </p>
         * 
         * @param key
         *        A string that contains <code>Tag</code> key.</p>
         *        <p>
         *        The string length should be between 1 and 128 characters. Valid characters include <code>a-z</code>,
         *        <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A string that contains an optional <code>Tag</code> value.
         * </p>
         * <p>
         * The string length should be between 0 and 256 characters. Valid characters include <code>a-z</code>,
         * <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
         * </p>
         * 
         * @param value
         *        A string that contains an optional <code>Tag</code> value.</p>
         *        <p>
         *        The string length should be between 0 and 256 characters. Valid characters include <code>a-z</code>,
         *        <code>A-Z</code>, <code>0-9</code>, space, and the special characters <code>_ - . : / = + @</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }
    }
}
