/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the Amazon S3 bucket from which you want CloudFront to get your media
 * files for distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Origin implements ToCopyableBuilder<S3Origin.Builder, S3Origin> {
    private final String domainName;

    private final String originAccessIdentity;

    private S3Origin(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.originAccessIdentity = builder.originAccessIdentity;
    }

    /**
     * <p>
     * The DNS name of the Amazon S3 origin.
     * </p>
     * 
     * @return The DNS name of the Amazon S3 origin.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The CloudFront origin access identity to associate with the RTMP distribution. Use an origin access identity to
     * configure the distribution so that end users can only access objects in an Amazon S3 bucket through CloudFront.
     * </p>
     * <p>
     * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL, specify
     * an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To delete the origin access identity from an existing distribution, update the distribution configuration and
     * include an empty <code>OriginAccessIdentity</code> element.
     * </p>
     * <p>
     * To replace the origin access identity, update the distribution configuration and specify the new origin access
     * identity.
     * </p>
     * <p>
     * For more information, see <a href=
     * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     * >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>Amazon Amazon
     * CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The CloudFront origin access identity to associate with the RTMP distribution. Use an origin access
     *         identity to configure the distribution so that end users can only access objects in an Amazon S3 bucket
     *         through CloudFront.</p>
     *         <p>
     *         If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
     *         specify an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To delete the origin access identity from an existing distribution, update the distribution configuration
     *         and include an empty <code>OriginAccessIdentity</code> element.
     *         </p>
     *         <p>
     *         To replace the origin access identity, update the distribution configuration and specify the new origin
     *         access identity.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *         >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>Amazon Amazon
     *         CloudFront Developer Guide</i>.
     */
    public String originAccessIdentity() {
        return originAccessIdentity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(originAccessIdentity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Origin)) {
            return false;
        }
        S3Origin other = (S3Origin) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(originAccessIdentity(), other.originAccessIdentity());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (originAccessIdentity() != null) {
            sb.append("OriginAccessIdentity: ").append(originAccessIdentity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "OriginAccessIdentity":
            return Optional.of(clazz.cast(originAccessIdentity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, S3Origin> {
        /**
         * <p>
         * The DNS name of the Amazon S3 origin.
         * </p>
         * 
         * @param domainName
         *        The DNS name of the Amazon S3 origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The CloudFront origin access identity to associate with the RTMP distribution. Use an origin access identity
         * to configure the distribution so that end users can only access objects in an Amazon S3 bucket through
         * CloudFront.
         * </p>
         * <p>
         * If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3 URL,
         * specify an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To delete the origin access identity from an existing distribution, update the distribution configuration and
         * include an empty <code>OriginAccessIdentity</code> element.
         * </p>
         * <p>
         * To replace the origin access identity, update the distribution configuration and specify the new origin
         * access identity.
         * </p>
         * <p>
         * For more information, see <a href=
         * "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
         * >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>Amazon Amazon
         * CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param originAccessIdentity
         *        The CloudFront origin access identity to associate with the RTMP distribution. Use an origin access
         *        identity to configure the distribution so that end users can only access objects in an Amazon S3
         *        bucket through CloudFront.</p>
         *        <p>
         *        If you want end users to be able to access objects using either the CloudFront URL or the Amazon S3
         *        URL, specify an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To delete the origin access identity from an existing distribution, update the distribution
         *        configuration and include an empty <code>OriginAccessIdentity</code> element.
         *        </p>
         *        <p>
         *        To replace the origin access identity, update the distribution configuration and specify the new
         *        origin access identity.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
         *        >Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content</a> in the <i>Amazon
         *        Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessIdentity(String originAccessIdentity);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String originAccessIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Origin model) {
            domainName(model.domainName);
            originAccessIdentity(model.originAccessIdentity);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOriginAccessIdentity() {
            return originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        public S3Origin build() {
            return new S3Origin(this);
        }
    }
}
