/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains a Lambda function association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LambdaFunctionAssociation implements ToCopyableBuilder<LambdaFunctionAssociation.Builder, LambdaFunctionAssociation> {
    private final String lambdaFunctionARN;

    private final String eventType;

    private LambdaFunctionAssociation(BuilderImpl builder) {
        this.lambdaFunctionARN = builder.lambdaFunctionARN;
        this.eventType = builder.eventType;
    }

    /**
     * <p>
     * The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a Lambda alias
     * or $LATEST.
     * </p>
     * 
     * @return The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a
     *         Lambda alias or $LATEST.
     */
    public String lambdaFunctionARN() {
        return lambdaFunctionARN;
    }

    /**
     * <p>
     * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and before it
     * checks to see whether the requested object is in the edge cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin. When
     * the requested object is in the edge cache, the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
     * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't
     * execute.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
     * The function executes regardless of whether the object was already in the edge cache.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeString}.
     * </p>
     * 
     * @return Specifies the event type that triggers a Lambda function invocation. You can specify the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
     *         before it checks to see whether the requested object is in the edge cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
     *         origin. When the requested object is in the edge cache, the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-response</code>: The function executes after CloudFront receives a response from the origin
     *         and before it caches the object in the response. When the requested object is in the edge cache, the
     *         function doesn't execute.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
     *         viewer. The function executes regardless of whether the object was already in the edge cache.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     * @see EventType
     */
    public EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and before it
     * checks to see whether the requested object is in the edge cache.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin. When
     * the requested object is in the edge cache, the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
     * before it caches the object in the response. When the requested object is in the edge cache, the function doesn't
     * execute.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the viewer.
     * The function executes regardless of whether the object was already in the edge cache.
     * </p>
     * <p>
     * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeString}.
     * </p>
     * 
     * @return Specifies the event type that triggers a Lambda function invocation. You can specify the following
     *         values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
     *         before it checks to see whether the requested object is in the edge cache.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
     *         origin. When the requested object is in the edge cache, the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>origin-response</code>: The function executes after CloudFront receives a response from the origin
     *         and before it caches the object in the response. When the requested object is in the edge cache, the
     *         function doesn't execute.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
     *         viewer. The function executes regardless of whether the object was already in the edge cache.
     *         </p>
     *         <p>
     *         If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
     *         </p>
     *         </li>
     * @see EventType
     */
    public String eventTypeString() {
        return eventType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionARN());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionAssociation)) {
            return false;
        }
        LambdaFunctionAssociation other = (LambdaFunctionAssociation) obj;
        return Objects.equals(lambdaFunctionARN(), other.lambdaFunctionARN())
                && Objects.equals(eventTypeString(), other.eventTypeString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (lambdaFunctionARN() != null) {
            sb.append("LambdaFunctionARN: ").append(lambdaFunctionARN()).append(",");
        }
        if (eventTypeString() != null) {
            sb.append("EventType: ").append(eventTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaFunctionARN":
            return Optional.of(clazz.cast(lambdaFunctionARN()));
        case "EventType":
            return Optional.of(clazz.cast(eventTypeString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LambdaFunctionAssociation> {
        /**
         * <p>
         * The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a Lambda
         * alias or $LATEST.
         * </p>
         * 
         * @param lambdaFunctionARN
         *        The ARN of the Lambda function. You must specify the ARN of a function version; you can't specify a
         *        Lambda alias or $LATEST.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionARN(String lambdaFunctionARN);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
         * before it checks to see whether the requested object is in the edge cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin.
         * When the requested object is in the edge cache, the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function
         * doesn't execute.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
         * viewer. The function executes regardless of whether the object was already in the edge cache.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. You can specify the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
         *        and before it checks to see whether the requested object is in the edge cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
         *        origin. When the requested object is in the edge cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>: The function executes after CloudFront receives a response from the
         *        origin and before it caches the object in the response. When the requested object is in the edge
         *        cache, the function doesn't execute.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>: The function executes before CloudFront returns the requested object to
         *        the viewer. The function executes regardless of whether the object was already in the edge cache.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * Specifies the event type that triggers a Lambda function invocation. You can specify the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer and
         * before it checks to see whether the requested object is in the edge cache.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-request</code>: The function executes only when CloudFront forwards a request to your origin.
         * When the requested object is in the edge cache, the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>origin-response</code>: The function executes after CloudFront receives a response from the origin and
         * before it caches the object in the response. When the requested object is in the edge cache, the function
         * doesn't execute.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>viewer-response</code>: The function executes before CloudFront returns the requested object to the
         * viewer. The function executes regardless of whether the object was already in the edge cache.
         * </p>
         * <p>
         * If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        Specifies the event type that triggers a Lambda function invocation. You can specify the following
         *        values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>viewer-request</code>: The function executes when CloudFront receives a request from a viewer
         *        and before it checks to see whether the requested object is in the edge cache.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-request</code>: The function executes only when CloudFront forwards a request to your
         *        origin. When the requested object is in the edge cache, the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>origin-response</code>: The function executes after CloudFront receives a response from the
         *        origin and before it caches the object in the response. When the requested object is in the edge
         *        cache, the function doesn't execute.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>viewer-response</code>: The function executes before CloudFront returns the requested object to
         *        the viewer. The function executes regardless of whether the object was already in the edge cache.
         *        </p>
         *        <p>
         *        If the origin returns an HTTP status code other than HTTP 200 (OK), the function doesn't execute.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaFunctionARN;

        private String eventType;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionAssociation model) {
            lambdaFunctionARN(model.lambdaFunctionARN);
            eventType(model.eventType);
        }

        public final String getLambdaFunctionARN() {
            return lambdaFunctionARN;
        }

        @Override
        public final Builder lambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
            return this;
        }

        public final void setLambdaFunctionARN(String lambdaFunctionARN) {
            this.lambdaFunctionARN = lambdaFunctionARN;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public LambdaFunctionAssociation build() {
            return new LambdaFunctionAssociation(this);
        }
    }
}
