/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to create a new distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDistributionRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateDistributionRequest.Builder, CreateDistributionRequest> {
    private final DistributionConfig distributionConfig;

    private CreateDistributionRequest(BuilderImpl builder) {
        super(builder);
        this.distributionConfig = builder.distributionConfig;
    }

    /**
     * <p>
     * The distribution's configuration information.
     * </p>
     * 
     * @return The distribution's configuration information.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDistributionRequest)) {
            return false;
        }
        CreateDistributionRequest other = (CreateDistributionRequest) obj;
        return Objects.equals(distributionConfig(), other.distributionConfig());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distributionConfig() != null) {
            sb.append("DistributionConfig: ").append(distributionConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionConfig":
            return Optional.of(clazz.cast(distributionConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CloudFrontRequest.Builder, CopyableBuilder<Builder, CreateDistributionRequest> {
        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * 
         * @param distributionConfig
         *        The distribution's configuration information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);

        /**
         * <p>
         * The distribution's configuration information.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfig.Builder} avoiding the need to
         * create one manually via {@link DistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionConfig(DistributionConfig)}.
         * 
         * @param distributionConfig
         *        a consumer that will call methods on {@link DistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfig(DistributionConfig)
         */
        default Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return distributionConfig(DistributionConfig.builder().apply(distributionConfig).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private DistributionConfig distributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDistributionRequest model) {
            distributionConfig(model.distributionConfig);
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return distributionConfig != null ? distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDistributionRequest build() {
            return new CreateDistributionRequest(this);
        }
    }
}
