/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.cloudfront.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * DeleteStreamingDistributionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteStreamingDistributionRequestMarshaller implements
        Marshaller<Request<DeleteStreamingDistributionRequest>, DeleteStreamingDistributionRequest> {

    public Request<DeleteStreamingDistributionRequest> marshall(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {

        if (deleteStreamingDistributionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteStreamingDistributionRequest> request = new DefaultRequest<DeleteStreamingDistributionRequest>(
                deleteStreamingDistributionRequest, "CloudFrontClient");

        request.setHttpMethod(HttpMethodName.DELETE);

        if (deleteStreamingDistributionRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(deleteStreamingDistributionRequest.ifMatch()));
        }

        String uriResourcePath = "/2017-03-25/streaming-distribution/{Id}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Id", deleteStreamingDistributionRequest.id());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}