/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDistributionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateDistributionResponse.Builder, UpdateDistributionResponse> {
    private final Distribution distribution;

    private final String eTag;

    private UpdateDistributionResponse(BuilderImpl builder) {
        this.distribution = builder.distribution;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The distribution's information.
     * </p>
     * 
     * @return The distribution's information.
     */
    public Distribution distribution() {
        return distribution;
    }

    /**
     * <p>
     * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distribution());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionResponse)) {
            return false;
        }
        UpdateDistributionResponse other = (UpdateDistributionResponse) obj;
        return Objects.equals(distribution(), other.distribution()) && Objects.equals(eTag(), other.eTag());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distribution() != null) {
            sb.append("Distribution: ").append(distribution()).append(",");
        }
        if (eTag() != null) {
            sb.append("ETag: ").append(eTag()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Distribution":
            return Optional.of(clazz.cast(distribution()));
        case "ETag":
            return Optional.of(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDistributionResponse> {
        /**
         * <p>
         * The distribution's information.
         * </p>
         * 
         * @param distribution
         *        The distribution's information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The distribution's information.
         * </p>
         * This is a convenience that creates an instance of the {@link Distribution.Builder} avoiding the need to
         * create one manually via {@link Distribution#builder()}.
         *
         * When the {@link Consumer} completes, {@link Distribution.Builder#build()} is called immediately and its
         * result is passed to {@link #distribution(Distribution)}.
         * 
         * @param distribution
         *        a consumer that will call methods on {@link Distribution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distribution(Distribution)
         */
        default Builder distribution(Consumer<Distribution.Builder> distribution) {
            return distribution(Distribution.builder().apply(distribution).build());
        }

        /**
         * <p>
         * The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param eTag
         *        The current version of the configuration. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl implements Builder {
        private Distribution distribution;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionResponse model) {
            distribution(model.distribution);
            eTag(model.eTag);
        }

        public final Distribution.Builder getDistribution() {
            return distribution != null ? distribution.toBuilder() : null;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution = distribution;
            return this;
        }

        public final void setDistribution(Distribution.BuilderImpl distribution) {
            this.distribution = distribution != null ? distribution.build() : null;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public UpdateDistributionResponse build() {
            return new UpdateDistributionResponse(this);
        }
    }
}
