/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamingDistributionList implements ToCopyableBuilder<StreamingDistributionList.Builder, StreamingDistributionList> {
    private final String marker;

    private final String nextMarker;

    private final Integer maxItems;

    private final Boolean isTruncated;

    private final Integer quantity;

    private final List<StreamingDistributionSummary> items;

    private StreamingDistributionList(BuilderImpl builder) {
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.isTruncated = builder.isTruncated;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The value you provided for the <code>Marker</code> request parameter.
     * </p>
     * 
     * @return The value you provided for the <code>Marker</code> request parameter.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use for
     * the <code>Marker</code> request parameter to continue listing your RTMP distributions where they left off.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can
     *         use for the <code>Marker</code> request parameter to continue listing your RTMP distributions where they
     *         left off.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value you provided for the <code>MaxItems</code> request parameter.
     * </p>
     * 
     * @return The value you provided for the <code>MaxItems</code> request parameter.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * A flag that indicates whether more streaming distributions remain to be listed. If your results were truncated,
     * you can make a follow-up pagination request using the <code>Marker</code> request parameter to retrieve more
     * distributions in the list.
     * </p>
     * 
     * @return A flag that indicates whether more streaming distributions remain to be listed. If your results were
     *         truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
     *         retrieve more distributions in the list.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The number of streaming distributions that were created by the current AWS account.
     * </p>
     * 
     * @return The number of streaming distributions that were created by the current AWS account.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * A complex type that contains one <code>StreamingDistributionSummary</code> element for each distribution that was
     * created by the current AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains one <code>StreamingDistributionSummary</code> element for each distribution
     *         that was created by the current AWS account.
     */
    public List<StreamingDistributionSummary> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(items());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistributionList)) {
            return false;
        }
        StreamingDistributionList other = (StreamingDistributionList) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(maxItems(), other.maxItems()) && Objects.equals(isTruncated(), other.isTruncated())
                && Objects.equals(quantity(), other.quantity()) && Objects.equals(items(), other.items());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "NextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        case "IsTruncated":
            return Optional.of(clazz.cast(isTruncated()));
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StreamingDistributionList> {
        /**
         * <p>
         * The value you provided for the <code>Marker</code> request parameter.
         * </p>
         * 
         * @param marker
         *        The value you provided for the <code>Marker</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you can use
         * for the <code>Marker</code> request parameter to continue listing your RTMP distributions where they left
         * off.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, this element is present and contains the value you
         *        can use for the <code>Marker</code> request parameter to continue listing your RTMP distributions
         *        where they left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value you provided for the <code>MaxItems</code> request parameter.
         * </p>
         * 
         * @param maxItems
         *        The value you provided for the <code>MaxItems</code> request parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * A flag that indicates whether more streaming distributions remain to be listed. If your results were
         * truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter to
         * retrieve more distributions in the list.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether more streaming distributions remain to be listed. If your results were
         *        truncated, you can make a follow-up pagination request using the <code>Marker</code> request parameter
         *        to retrieve more distributions in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The number of streaming distributions that were created by the current AWS account.
         * </p>
         * 
         * @param quantity
         *        The number of streaming distributions that were created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * A complex type that contains one <code>StreamingDistributionSummary</code> element for each distribution that
         * was created by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>StreamingDistributionSummary</code> element for each
         *        distribution that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<StreamingDistributionSummary> items);

        /**
         * <p>
         * A complex type that contains one <code>StreamingDistributionSummary</code> element for each distribution that
         * was created by the current AWS account.
         * </p>
         * 
         * @param items
         *        A complex type that contains one <code>StreamingDistributionSummary</code> element for each
         *        distribution that was created by the current AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(StreamingDistributionSummary... items);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String nextMarker;

        private Integer maxItems;

        private Boolean isTruncated;

        private Integer quantity;

        private List<StreamingDistributionSummary> items;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistributionList model) {
            marker(model.marker);
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            isTruncated(model.isTruncated);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<StreamingDistributionSummary.Builder> getItems() {
            return items != null ? items.stream().map(StreamingDistributionSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder items(Collection<StreamingDistributionSummary> items) {
            this.items = StreamingDistributionSummaryListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(StreamingDistributionSummary... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<StreamingDistributionSummary.BuilderImpl> items) {
            this.items = StreamingDistributionSummaryListCopier.copyFromBuilder(items);
        }

        @Override
        public StreamingDistributionList build() {
            return new StreamingDistributionList(this);
        }
    }
}
