/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that lists the AWS accounts that were included in the <code>TrustedSigners</code> complex type, as
 * well as their active CloudFront key pair IDs, if any.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Signer implements ToCopyableBuilder<Signer.Builder, Signer> {
    private final String awsAccountNumber;

    private final KeyPairIds keyPairIds;

    private Signer(BuilderImpl builder) {
        this.awsAccountNumber = builder.awsAccountNumber;
        this.keyPairIds = builder.keyPairIds;
    }

    /**
     * <p>
     * An AWS account that is included in the <code>TrustedSigners</code> complex type for this RTMP distribution. Valid
     * values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>self</code>, which is the AWS account used to create the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS account number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return An AWS account that is included in the <code>TrustedSigners</code> complex type for this RTMP
     *         distribution. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>self</code>, which is the AWS account used to create the distribution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An AWS account number.
     *         </p>
     *         </li>
     */
    public String awsAccountNumber() {
        return awsAccountNumber;
    }

    /**
     * <p>
     * A complex type that lists the active CloudFront key pairs, if any, that are associated with
     * <code>AwsAccountNumber</code>.
     * </p>
     * 
     * @return A complex type that lists the active CloudFront key pairs, if any, that are associated with
     *         <code>AwsAccountNumber</code>.
     */
    public KeyPairIds keyPairIds() {
        return keyPairIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signer)) {
            return false;
        }
        Signer other = (Signer) obj;
        return Objects.equals(awsAccountNumber(), other.awsAccountNumber()) && Objects.equals(keyPairIds(), other.keyPairIds());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (awsAccountNumber() != null) {
            sb.append("AwsAccountNumber: ").append(awsAccountNumber()).append(",");
        }
        if (keyPairIds() != null) {
            sb.append("KeyPairIds: ").append(keyPairIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountNumber":
            return Optional.of(clazz.cast(awsAccountNumber()));
        case "KeyPairIds":
            return Optional.of(clazz.cast(keyPairIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Signer> {
        /**
         * <p>
         * An AWS account that is included in the <code>TrustedSigners</code> complex type for this RTMP distribution.
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>self</code>, which is the AWS account used to create the distribution.
         * </p>
         * </li>
         * <li>
         * <p>
         * An AWS account number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param awsAccountNumber
         *        An AWS account that is included in the <code>TrustedSigners</code> complex type for this RTMP
         *        distribution. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>self</code>, which is the AWS account used to create the distribution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An AWS account number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountNumber(String awsAccountNumber);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * 
         * @param keyPairIds
         *        A complex type that lists the active CloudFront key pairs, if any, that are associated with
         *        <code>AwsAccountNumber</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairIds(KeyPairIds keyPairIds);

        /**
         * <p>
         * A complex type that lists the active CloudFront key pairs, if any, that are associated with
         * <code>AwsAccountNumber</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link KeyPairIds.Builder} avoiding the need to create
         * one manually via {@link KeyPairIds#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPairIds.Builder#build()} is called immediately and its result
         * is passed to {@link #keyPairIds(KeyPairIds)}.
         * 
         * @param keyPairIds
         *        a consumer that will call methods on {@link KeyPairIds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPairIds(KeyPairIds)
         */
        default Builder keyPairIds(Consumer<KeyPairIds.Builder> keyPairIds) {
            return keyPairIds(KeyPairIds.builder().apply(keyPairIds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountNumber;

        private KeyPairIds keyPairIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Signer model) {
            awsAccountNumber(model.awsAccountNumber);
            keyPairIds(model.keyPairIds);
        }

        public final String getAwsAccountNumber() {
            return awsAccountNumber;
        }

        @Override
        public final Builder awsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
            return this;
        }

        public final void setAwsAccountNumber(String awsAccountNumber) {
            this.awsAccountNumber = awsAccountNumber;
        }

        public final KeyPairIds.Builder getKeyPairIds() {
            return keyPairIds != null ? keyPairIds.toBuilder() : null;
        }

        @Override
        public final Builder keyPairIds(KeyPairIds keyPairIds) {
            this.keyPairIds = keyPairIds;
            return this;
        }

        public final void setKeyPairIds(KeyPairIds.BuilderImpl keyPairIds) {
            this.keyPairIds = keyPairIds != null ? keyPairIds.build() : null;
        }

        @Override
        public Signer build() {
            return new Signer(this);
        }
    }
}
