/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourceResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private final Tags tags;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>Tag</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>Tag</code> elements.
     */
    public Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * 
         * @param tags
         *        A complex type that contains zero or more <code>Tag</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * <p>
         * A complex type that contains zero or more <code>Tag</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link Tags.Builder} avoiding the need to create one
         * manually via {@link Tags#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().apply(tags).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            tags(model.tags);
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }
    }
}
