/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information about a CloudFront distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DistributionSummary implements ToCopyableBuilder<DistributionSummary.Builder, DistributionSummary> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final Aliases aliases;

    private final Origins origins;

    private final DefaultCacheBehavior defaultCacheBehavior;

    private final CacheBehaviors cacheBehaviors;

    private final CustomErrorResponses customErrorResponses;

    private final String comment;

    private final String priceClass;

    private final Boolean enabled;

    private final ViewerCertificate viewerCertificate;

    private final Restrictions restrictions;

    private final String webACLId;

    private final String httpVersion;

    private final Boolean isIPV6Enabled;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
    }

    /**
     * <p>
     * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is
     * your AWS account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your AWS account ID.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's information
     * is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the distribution, for example,
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         distribution.
     */
    public Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public Origins origins() {
        return origins;
    }

    /**
     * <p>
     * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
     * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
     * elements. You must create exactly one default cache behavior.
     * </p>
     * 
     * @return A complex type that describes the default cache behavior if you don't specify a
     *         <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code>
     *         in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.
     */
    public DefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CacheBehavior</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CacheBehavior</code> elements.
     */
    public CacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
     */
    public CustomErrorResponses customErrorResponses() {
        return customErrorResponses;
    }

    /**
     * <p>
     * The comment originally specified when this distribution was created.
     * </p>
     * 
     * @return The comment originally specified when this distribution was created.
     */
    public String comment() {
        return comment;
    }

    /**
     * Returns the value of the PriceClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassString}.
     * </p>
     * 
     * @return The value of the PriceClass property for this object.
     * @see PriceClass
     */
    public PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * Returns the value of the PriceClass property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassString}.
     * </p>
     * 
     * @return The value of the PriceClass property for this object.
     * @see PriceClass
     */
    public String priceClassString() {
        return priceClass;
    }

    /**
     * <p>
     * Whether the distribution is enabled to accept user requests for content.
     * </p>
     * 
     * @return Whether the distribution is enabled to accept user requests for content.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the ViewerCertificate property for this object.
     * 
     * @return The value of the ViewerCertificate property for this object.
     */
    public ViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * Returns the value of the Restrictions property for this object.
     * 
     * @return The value of the Restrictions property for this object.
     */
    public Restrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * The Web ACL Id (if any) associated with the distribution.
     * </p>
     * 
     * @return The Web ACL Id (if any) associated with the distribution.
     */
    public String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value
     * for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
     * automatically use an earlier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionString}.
     * </p>
     * 
     * @return Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
     *         value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code>
     *         will automatically use an earlier version.
     * @see HttpVersion
     */
    public HttpVersion httpVersion() {
        return HttpVersion.fromValue(httpVersion);
    }

    /**
     * <p>
     * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default value
     * for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
     * automatically use an earlier version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionString}.
     * </p>
     * 
     * @return Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
     *         value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code>
     *         will automatically use an earlier version.
     * @see HttpVersion
     */
    public String httpVersionString() {
        return httpVersion;
    }

    /**
     * <p>
     * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     * </p>
     * 
     * @return Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
     */
    public Boolean isIPV6Enabled() {
        return isIPV6Enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(httpVersionString());
        hashCode = 31 * hashCode + Objects.hashCode(isIPV6Enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(aliases(), other.aliases())
                && Objects.equals(origins(), other.origins())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(customErrorResponses(), other.customErrorResponses())
                && Objects.equals(comment(), other.comment()) && Objects.equals(priceClassString(), other.priceClassString())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(viewerCertificate(), other.viewerCertificate())
                && Objects.equals(restrictions(), other.restrictions()) && Objects.equals(webACLId(), other.webACLId())
                && Objects.equals(httpVersionString(), other.httpVersionString())
                && Objects.equals(isIPV6Enabled(), other.isIPV6Enabled());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (arn() != null) {
            sb.append("ARN: ").append(arn()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(lastModifiedTime()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (aliases() != null) {
            sb.append("Aliases: ").append(aliases()).append(",");
        }
        if (origins() != null) {
            sb.append("Origins: ").append(origins()).append(",");
        }
        if (defaultCacheBehavior() != null) {
            sb.append("DefaultCacheBehavior: ").append(defaultCacheBehavior()).append(",");
        }
        if (cacheBehaviors() != null) {
            sb.append("CacheBehaviors: ").append(cacheBehaviors()).append(",");
        }
        if (customErrorResponses() != null) {
            sb.append("CustomErrorResponses: ").append(customErrorResponses()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (priceClassString() != null) {
            sb.append("PriceClass: ").append(priceClassString()).append(",");
        }
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (viewerCertificate() != null) {
            sb.append("ViewerCertificate: ").append(viewerCertificate()).append(",");
        }
        if (restrictions() != null) {
            sb.append("Restrictions: ").append(restrictions()).append(",");
        }
        if (webACLId() != null) {
            sb.append("WebACLId: ").append(webACLId()).append(",");
        }
        if (httpVersionString() != null) {
            sb.append("HttpVersion: ").append(httpVersionString()).append(",");
        }
        if (isIPV6Enabled() != null) {
            sb.append("IsIPV6Enabled: ").append(isIPV6Enabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.of(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "Aliases":
            return Optional.of(clazz.cast(aliases()));
        case "Origins":
            return Optional.of(clazz.cast(origins()));
        case "DefaultCacheBehavior":
            return Optional.of(clazz.cast(defaultCacheBehavior()));
        case "CacheBehaviors":
            return Optional.of(clazz.cast(cacheBehaviors()));
        case "CustomErrorResponses":
            return Optional.of(clazz.cast(customErrorResponses()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "PriceClass":
            return Optional.of(clazz.cast(priceClassString()));
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "ViewerCertificate":
            return Optional.of(clazz.cast(viewerCertificate()));
        case "Restrictions":
            return Optional.of(clazz.cast(restrictions()));
        case "WebACLId":
            return Optional.of(clazz.cast(webACLId()));
        case "HttpVersion":
            return Optional.of(clazz.cast(httpVersionString()));
        case "IsIPV6Enabled":
            return Optional.of(clazz.cast(isIPV6Enabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DistributionSummary> {
        /**
         * <p>
         * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code>
         * is your AWS account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the distribution. When the status is <code>Deployed</code>, the distribution's
         *        information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>
         * .
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the distribution, for example,
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Aliases.Builder} avoiding the need to create one
         * manually via {@link Aliases#builder()}.
         *
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().apply(aliases).build());
        }

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(Origins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience that creates an instance of the {@link Origins.Builder} avoiding the need to create one
         * manually via {@link Origins#builder()}.
         *
         * When the {@link Consumer} completes, {@link Origins.Builder#build()} is called immediately and its result is
         * passed to {@link #origins(Origins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link Origins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(Origins)
         */
        default Builder origins(Consumer<Origins.Builder> origins) {
            return origins(Origins.builder().apply(origins).build());
        }

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        A complex type that describes the default cache behavior if you don't specify a
         *        <code>CacheBehavior</code> element or if files don't match any of the values of
         *        <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default
         *        cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * This is a convenience that creates an instance of the {@link DefaultCacheBehavior.Builder} avoiding the need
         * to create one manually via {@link DefaultCacheBehavior#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultCacheBehavior.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultCacheBehavior(DefaultCacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link DefaultCacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(DefaultCacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(DefaultCacheBehavior.builder().apply(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * 
         * @param cacheBehaviors
         *        A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviors cacheBehaviors);

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link CacheBehaviors.Builder} avoiding the need to
         * create one manually via {@link CacheBehaviors#builder()}.
         *
         * When the {@link Consumer} completes, {@link CacheBehaviors.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviors(CacheBehaviors)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link CacheBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(CacheBehaviors)
         */
        default Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return cacheBehaviors(CacheBehaviors.builder().apply(cacheBehaviors).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * </p>
         * 
         * @param customErrorResponses
         *        A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customErrorResponses(CustomErrorResponses customErrorResponses);

        /**
         * <p>
         * A complex type that contains zero or more <code>CustomErrorResponses</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomErrorResponses.Builder} avoiding the need
         * to create one manually via {@link CustomErrorResponses#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomErrorResponses.Builder#build()} is called immediately and
         * its result is passed to {@link #customErrorResponses(CustomErrorResponses)}.
         * 
         * @param customErrorResponses
         *        a consumer that will call methods on {@link CustomErrorResponses.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customErrorResponses(CustomErrorResponses)
         */
        default Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return customErrorResponses(CustomErrorResponses.builder().apply(customErrorResponses).build());
        }

        /**
         * <p>
         * The comment originally specified when this distribution was created.
         * </p>
         * 
         * @param comment
         *        The comment originally specified when this distribution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * Sets the value of the PriceClass property for this object.
         *
         * @param priceClass
         *        The new value for the PriceClass property for this object.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * Whether the distribution is enabled to accept user requests for content.
         * </p>
         * 
         * @param enabled
         *        Whether the distribution is enabled to accept user requests for content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the ViewerCertificate property for this object.
         *
         * @param viewerCertificate
         *        The new value for the ViewerCertificate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(ViewerCertificate viewerCertificate);

        /**
         * Sets the value of the ViewerCertificate property for this object.
         *
         * This is a convenience that creates an instance of the {@link ViewerCertificate.Builder} avoiding the need to
         * create one manually via {@link ViewerCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ViewerCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #viewerCertificate(ViewerCertificate)}.
         * 
         * @param viewerCertificate
         *        a consumer that will call methods on {@link ViewerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewerCertificate(ViewerCertificate)
         */
        default Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return viewerCertificate(ViewerCertificate.builder().apply(viewerCertificate).build());
        }

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * @param restrictions
         *        The new value for the Restrictions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Restrictions restrictions);

        /**
         * Sets the value of the Restrictions property for this object.
         *
         * This is a convenience that creates an instance of the {@link Restrictions.Builder} avoiding the need to
         * create one manually via {@link Restrictions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Restrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(Restrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link Restrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(Restrictions)
         */
        default Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return restrictions(Restrictions.builder().apply(restrictions).build());
        }

        /**
         * <p>
         * The Web ACL Id (if any) associated with the distribution.
         * </p>
         * 
         * @param webACLId
         *        The Web ACL Id (if any) associated with the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The default
         * value for new web distributions is <code>http2</code>. Viewers that don't support <code>HTTP/2</code> will
         * automatically use an earlier version.
         * </p>
         * 
         * @param httpVersion
         *        Specify the maximum HTTP version that you want viewers to use to communicate with CloudFront. The
         *        default value for new web distributions is <code>http2</code>. Viewers that don't support
         *        <code>HTTP/2</code> will automatically use an earlier version.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(HttpVersion httpVersion);

        /**
         * <p>
         * Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * </p>
         * 
         * @param isIPV6Enabled
         *        Whether CloudFront responds to IPv6 DNS requests with an IPv6 address for your distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIPV6Enabled(Boolean isIPV6Enabled);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private Aliases aliases;

        private Origins origins;

        private DefaultCacheBehavior defaultCacheBehavior;

        private CacheBehaviors cacheBehaviors;

        private CustomErrorResponses customErrorResponses;

        private String comment;

        private String priceClass;

        private Boolean enabled;

        private ViewerCertificate viewerCertificate;

        private Restrictions restrictions;

        private String webACLId;

        private String httpVersion;

        private Boolean isIPV6Enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            aliases(model.aliases);
            origins(model.origins);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviors(model.cacheBehaviors);
            customErrorResponses(model.customErrorResponses);
            comment(model.comment);
            priceClass(model.priceClass);
            enabled(model.enabled);
            viewerCertificate(model.viewerCertificate);
            restrictions(model.restrictions);
            webACLId(model.webACLId);
            httpVersion(model.httpVersion);
            isIPV6Enabled(model.isIPV6Enabled);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        public final Origins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.toBuilder() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return customErrorResponses != null ? customErrorResponses.toBuilder() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass.toString());
            return this;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return viewerCertificate != null ? viewerCertificate.toBuilder() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        public final Restrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion.toString());
            return this;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        public final Boolean getIsIPV6Enabled() {
            return isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public DistributionSummary build() {
            return new DistributionSummary(this);
        }
    }
}
