/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The distribution's information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Distribution implements ToCopyableBuilder<Distribution.Builder, Distribution> {
    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final Integer inProgressInvalidationBatches;

    private final String domainName;

    private final ActiveTrustedSigners activeTrustedSigners;

    private final DistributionConfig distributionConfig;

    private Distribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.inProgressInvalidationBatches = builder.inProgressInvalidationBatches;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.distributionConfig = builder.distributionConfig;
    }

    /**
     * <p>
     * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     * </p>
     * 
     * @return The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is
     * your AWS account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your AWS account ID.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * This response element indicates the current status of the distribution. When the status is <code>Deployed</code>,
     * the distribution's information is fully propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return This response element indicates the current status of the distribution. When the status is
     *         <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
     *         locations.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time the distribution was last modified.
     * </p>
     * 
     * @return The date and time the distribution was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The number of invalidation batches currently in progress.
     * </p>
     * 
     * @return The number of invalidation batches currently in progress.
     */
    public Integer inProgressInvalidationBatches() {
        return inProgressInvalidationBatches;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name corresponding to the distribution, for example,
     *         <code>d111111abcdef8.cloudfront.net</code>.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * CloudFront automatically adds this element to the response only if you've set up the distribution to serve
     * private content with signed URLs. The element lists the key pair IDs that CloudFront is aware of for each trusted
     * signer. The <code>Signer</code> child element lists the AWS account number of the trusted signer (or an empty
     * <code>Self</code> element if the signer is you). The <code>Signer</code> element also includes the IDs of any
     * active key pairs associated with the trusted signer's AWS account. If no <code>KeyPairId</code> element appears
     * for a <code>Signer</code>, that signer can't create working signed URLs.
     * </p>
     * 
     * @return CloudFront automatically adds this element to the response only if you've set up the distribution to
     *         serve private content with signed URLs. The element lists the key pair IDs that CloudFront is aware of
     *         for each trusted signer. The <code>Signer</code> child element lists the AWS account number of the
     *         trusted signer (or an empty <code>Self</code> element if the signer is you). The <code>Signer</code>
     *         element also includes the IDs of any active key pairs associated with the trusted signer's AWS account.
     *         If no <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create working
     *         signed URLs.
     */
    public ActiveTrustedSigners activeTrustedSigners() {
        return activeTrustedSigners;
    }

    /**
     * <p>
     * The current configuration information for the distribution. Send a <code>GET</code> request to the
     * <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.
     * </p>
     * 
     * @return The current configuration information for the distribution. Send a <code>GET</code> request to the
     *         <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.
     */
    public DistributionConfig distributionConfig() {
        return distributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(inProgressInvalidationBatches());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(distributionConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Distribution)) {
            return false;
        }
        Distribution other = (Distribution) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(inProgressInvalidationBatches(), other.inProgressInvalidationBatches())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(activeTrustedSigners(), other.activeTrustedSigners())
                && Objects.equals(distributionConfig(), other.distributionConfig());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (arn() != null) {
            sb.append("ARN: ").append(arn()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (lastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(lastModifiedTime()).append(",");
        }
        if (inProgressInvalidationBatches() != null) {
            sb.append("InProgressInvalidationBatches: ").append(inProgressInvalidationBatches()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (activeTrustedSigners() != null) {
            sb.append("ActiveTrustedSigners: ").append(activeTrustedSigners()).append(",");
        }
        if (distributionConfig() != null) {
            sb.append("DistributionConfig: ").append(distributionConfig()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.of(clazz.cast(lastModifiedTime()));
        case "InProgressInvalidationBatches":
            return Optional.of(clazz.cast(inProgressInvalidationBatches()));
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "ActiveTrustedSigners":
            return Optional.of(clazz.cast(activeTrustedSigners()));
        case "DistributionConfig":
            return Optional.of(clazz.cast(distributionConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Distribution> {
        /**
         * <p>
         * The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the distribution. For example: <code>EDFDVBD632BHDS5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code>
         * is your AWS account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * This response element indicates the current status of the distribution. When the status is
         * <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        This response element indicates the current status of the distribution. When the status is
         *        <code>Deployed</code>, the distribution's information is fully propagated to all CloudFront edge
         *        locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The number of invalidation batches currently in progress.
         * </p>
         * 
         * @param inProgressInvalidationBatches
         *        The number of invalidation batches currently in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressInvalidationBatches(Integer inProgressInvalidationBatches);

        /**
         * <p>
         * The domain name corresponding to the distribution, for example, <code>d111111abcdef8.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution, for example,
         *        <code>d111111abcdef8.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * CloudFront automatically adds this element to the response only if you've set up the distribution to serve
         * private content with signed URLs. The element lists the key pair IDs that CloudFront is aware of for each
         * trusted signer. The <code>Signer</code> child element lists the AWS account number of the trusted signer (or
         * an empty <code>Self</code> element if the signer is you). The <code>Signer</code> element also includes the
         * IDs of any active key pairs associated with the trusted signer's AWS account. If no <code>KeyPairId</code>
         * element appears for a <code>Signer</code>, that signer can't create working signed URLs.
         * </p>
         * 
         * @param activeTrustedSigners
         *        CloudFront automatically adds this element to the response only if you've set up the distribution to
         *        serve private content with signed URLs. The element lists the key pair IDs that CloudFront is aware of
         *        for each trusted signer. The <code>Signer</code> child element lists the AWS account number of the
         *        trusted signer (or an empty <code>Self</code> element if the signer is you). The <code>Signer</code>
         *        element also includes the IDs of any active key pairs associated with the trusted signer's AWS
         *        account. If no <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't
         *        create working signed URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners);

        /**
         * <p>
         * CloudFront automatically adds this element to the response only if you've set up the distribution to serve
         * private content with signed URLs. The element lists the key pair IDs that CloudFront is aware of for each
         * trusted signer. The <code>Signer</code> child element lists the AWS account number of the trusted signer (or
         * an empty <code>Self</code> element if the signer is you). The <code>Signer</code> element also includes the
         * IDs of any active key pairs associated with the trusted signer's AWS account. If no <code>KeyPairId</code>
         * element appears for a <code>Signer</code>, that signer can't create working signed URLs.
         * </p>
         * This is a convenience that creates an instance of the {@link ActiveTrustedSigners.Builder} avoiding the need
         * to create one manually via {@link ActiveTrustedSigners#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActiveTrustedSigners.Builder#build()} is called immediately and
         * its result is passed to {@link #activeTrustedSigners(ActiveTrustedSigners)}.
         * 
         * @param activeTrustedSigners
         *        a consumer that will call methods on {@link ActiveTrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeTrustedSigners(ActiveTrustedSigners)
         */
        default Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return activeTrustedSigners(ActiveTrustedSigners.builder().apply(activeTrustedSigners).build());
        }

        /**
         * <p>
         * The current configuration information for the distribution. Send a <code>GET</code> request to the
         * <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.
         * </p>
         * 
         * @param distributionConfig
         *        The current configuration information for the distribution. Send a <code>GET</code> request to the
         *        <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionConfig(DistributionConfig distributionConfig);

        /**
         * <p>
         * The current configuration information for the distribution. Send a <code>GET</code> request to the
         * <code>/<i>CloudFront API version</i>/distribution ID/config</code> resource.
         * </p>
         * This is a convenience that creates an instance of the {@link DistributionConfig.Builder} avoiding the need to
         * create one manually via {@link DistributionConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DistributionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #distributionConfig(DistributionConfig)}.
         * 
         * @param distributionConfig
         *        a consumer that will call methods on {@link DistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distributionConfig(DistributionConfig)
         */
        default Builder distributionConfig(Consumer<DistributionConfig.Builder> distributionConfig) {
            return distributionConfig(DistributionConfig.builder().apply(distributionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private Integer inProgressInvalidationBatches;

        private String domainName;

        private ActiveTrustedSigners activeTrustedSigners;

        private DistributionConfig distributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Distribution model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            inProgressInvalidationBatches(model.inProgressInvalidationBatches);
            domainName(model.domainName);
            activeTrustedSigners(model.activeTrustedSigners);
            distributionConfig(model.distributionConfig);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Integer getInProgressInvalidationBatches() {
            return inProgressInvalidationBatches;
        }

        @Override
        public final Builder inProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
            this.inProgressInvalidationBatches = inProgressInvalidationBatches;
            return this;
        }

        public final void setInProgressInvalidationBatches(Integer inProgressInvalidationBatches) {
            this.inProgressInvalidationBatches = inProgressInvalidationBatches;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return activeTrustedSigners != null ? activeTrustedSigners.toBuilder() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        public final DistributionConfig.Builder getDistributionConfig() {
            return distributionConfig != null ? distributionConfig.toBuilder() : null;
        }

        @Override
        public final Builder distributionConfig(DistributionConfig distributionConfig) {
            this.distributionConfig = distributionConfig;
            return this;
        }

        public final void setDistributionConfig(DistributionConfig.BuilderImpl distributionConfig) {
            this.distributionConfig = distributionConfig != null ? distributionConfig.build() : null;
        }

        @Override
        public Distribution build() {
            return new Distribution(this);
        }
    }
}
