/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes a origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteCloudFrontOriginAccessIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteCloudFrontOriginAccessIdentityRequest.Builder, DeleteCloudFrontOriginAccessIdentityRequest> {
    private final String id;

    private final String ifMatch;

    private DeleteCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The origin access identity's ID.
     * </p>
     * 
     * @return The origin access identity's ID.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code>
     * request. For example: <code>E2QWRUHAPOMQZL</code>.
     * </p>
     * 
     * @return The value of the <code>ETag</code> header you received from a previous <code>GET</code> or
     *         <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.
     */
    public String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        DeleteCloudFrontOriginAccessIdentityRequest other = (DeleteCloudFrontOriginAccessIdentityRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "IfMatch":
            return Optional.of(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteCloudFrontOriginAccessIdentityRequest> {
        /**
         * <p>
         * The origin access identity's ID.
         * </p>
         * 
         * @param id
         *        The origin access identity's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of the <code>ETag</code> header you received from a previous <code>GET</code> or <code>PUT</code>
         * request. For example: <code>E2QWRUHAPOMQZL</code>.
         * </p>
         * 
         * @param ifMatch
         *        The value of the <code>ETag</code> header you received from a previous <code>GET</code> or
         *        <code>PUT</code> request. For example: <code>E2QWRUHAPOMQZL</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCloudFrontOriginAccessIdentityRequest model) {
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public DeleteCloudFrontOriginAccessIdentityRequest build() {
            return new DeleteCloudFrontOriginAccessIdentityRequest(this);
        }
    }
}
