/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that identifies ways in which you want to restrict distribution of your content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Restrictions implements ToCopyableBuilder<Restrictions.Builder, Restrictions> {
    private final GeoRestriction geoRestriction;

    private Restrictions(BuilderImpl builder) {
        this.geoRestriction = builder.geoRestriction;
    }

    /**
     * Returns the value of the GeoRestriction property for this object.
     * 
     * @return The value of the GeoRestriction property for this object.
     */
    public GeoRestriction geoRestriction() {
        return geoRestriction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((geoRestriction() == null) ? 0 : geoRestriction().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Restrictions)) {
            return false;
        }
        Restrictions other = (Restrictions) obj;
        if (other.geoRestriction() == null ^ this.geoRestriction() == null) {
            return false;
        }
        if (other.geoRestriction() != null && !other.geoRestriction().equals(this.geoRestriction())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (geoRestriction() != null) {
            sb.append("GeoRestriction: ").append(geoRestriction()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GeoRestriction":
            return Optional.of(clazz.cast(geoRestriction()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Restrictions> {
        /**
         * Sets the value of the GeoRestriction property for this object.
         *
         * @param geoRestriction
         *        The new value for the GeoRestriction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoRestriction(GeoRestriction geoRestriction);
    }

    static final class BuilderImpl implements Builder {
        private GeoRestriction geoRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(Restrictions model) {
            geoRestriction(model.geoRestriction);
        }

        public final GeoRestriction.Builder getGeoRestriction() {
            return geoRestriction != null ? geoRestriction.toBuilder() : null;
        }

        @Override
        public final Builder geoRestriction(GeoRestriction geoRestriction) {
            this.geoRestriction = geoRestriction;
            return this;
        }

        public final void setGeoRestriction(GeoRestriction.BuilderImpl geoRestriction) {
            this.geoRestriction = geoRestriction != null ? geoRestriction.build() : null;
        }

        @Override
        public Restrictions build() {
            return new Restrictions(this);
        }
    }
}
