/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class QueryStringCacheKeys implements ToCopyableBuilder<QueryStringCacheKeys.Builder, QueryStringCacheKeys> {
    private final Integer quantity;

    private final List<String> items;

    private QueryStringCacheKeys(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * The number of <code>whitelisted</code> query string parameters for this cache behavior.
     * </p>
     * 
     * @return The number of <code>whitelisted</code> query string parameters for this cache behavior.
     */
    public Integer quantity() {
        return quantity;
    }

    /**
     * <p>
     * (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis for
     * caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis
     *         for caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
     */
    public List<String> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((quantity() == null) ? 0 : quantity().hashCode());
        hashCode = 31 * hashCode + ((items() == null) ? 0 : items().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStringCacheKeys)) {
            return false;
        }
        QueryStringCacheKeys other = (QueryStringCacheKeys) obj;
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        if (other.items() != null && !other.items().equals(this.items())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (quantity() != null) {
            sb.append("Quantity: ").append(quantity()).append(",");
        }
        if (items() != null) {
            sb.append("Items: ").append(items()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Quantity":
            return Optional.of(clazz.cast(quantity()));
        case "Items":
            return Optional.of(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, QueryStringCacheKeys> {
        /**
         * <p>
         * The number of <code>whitelisted</code> query string parameters for this cache behavior.
         * </p>
         * 
         * @param quantity
         *        The number of <code>whitelisted</code> query string parameters for this cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis for
         * caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis
         *        for caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<String> items);

        /**
         * <p>
         * (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis for
         * caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
         * </p>
         * 
         * @param items
         *        (Optional) A list that contains the query string parameters that you want CloudFront to use as a basis
         *        for caching for this cache behavior. If <code>Quantity</code> is 0, you can omit <code>Items</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(String... items);
    }

    static final class BuilderImpl implements Builder {
        private Integer quantity;

        private List<String> items;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStringCacheKeys model) {
            quantity(model.quantity);
            items(model.items);
        }

        public final Integer getQuantity() {
            return quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<String> getItems() {
            return items;
        }

        @Override
        public final Builder items(Collection<String> items) {
            this.items = QueryStringCacheKeysListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(String... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final void setItems(Collection<String> items) {
            this.items = QueryStringCacheKeysListCopier.copy(items);
        }

        @Override
        public QueryStringCacheKeys build() {
            return new QueryStringCacheKeys(this);
        }
    }
}
