/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list invalidations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListInvalidationsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListInvalidationsRequest.Builder, ListInvalidationsRequest> {
    private final String distributionId;

    private final String marker;

    private final String maxItems;

    private ListInvalidationsRequest(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The distribution's ID.
     * </p>
     * 
     * @return The distribution's ID.
     */
    public String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * Use this parameter when paginating results to indicate where to begin in your list of invalidation batches.
     * Because the results are returned in decreasing order from most recent to oldest, the most recent results are on
     * the first page, the second page will contain earlier results, and so on. To get the next page of results, set
     * <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This value is
     * the same as the ID of the last invalidation batch on that page.
     * </p>
     * 
     * @return Use this parameter when paginating results to indicate where to begin in your list of invalidation
     *         batches. Because the results are returned in decreasing order from most recent to oldest, the most recent
     *         results are on the first page, the second page will contain earlier results, and so on. To get the next
     *         page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the current
     *         page's response. This value is the same as the ID of the last invalidation batch on that page.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of invalidation batches that you want in the response body.
     * </p>
     * 
     * @return The maximum number of invalidation batches that you want in the response body.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionId() == null) ? 0 : distributionId().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvalidationsRequest)) {
            return false;
        }
        ListInvalidationsRequest other = (ListInvalidationsRequest) obj;
        if (other.distributionId() == null ^ this.distributionId() == null) {
            return false;
        }
        if (other.distributionId() != null && !other.distributionId().equals(this.distributionId())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distributionId() != null) {
            sb.append("DistributionId: ").append(distributionId()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.of(clazz.cast(distributionId()));
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListInvalidationsRequest> {
        /**
         * <p>
         * The distribution's ID.
         * </p>
         * 
         * @param distributionId
         *        The distribution's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * Use this parameter when paginating results to indicate where to begin in your list of invalidation batches.
         * Because the results are returned in decreasing order from most recent to oldest, the most recent results are
         * on the first page, the second page will contain earlier results, and so on. To get the next page of results,
         * set <code>Marker</code> to the value of the <code>NextMarker</code> from the current page's response. This
         * value is the same as the ID of the last invalidation batch on that page.
         * </p>
         * 
         * @param marker
         *        Use this parameter when paginating results to indicate where to begin in your list of invalidation
         *        batches. Because the results are returned in decreasing order from most recent to oldest, the most
         *        recent results are on the first page, the second page will contain earlier results, and so on. To get
         *        the next page of results, set <code>Marker</code> to the value of the <code>NextMarker</code> from the
         *        current page's response. This value is the same as the ID of the last invalidation batch on that page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of invalidation batches that you want in the response body.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of invalidation batches that you want in the response body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl implements Builder {
        private String distributionId;

        private String marker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvalidationsRequest model) {
            distributionId(model.distributionId);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListInvalidationsRequest build() {
            return new ListInvalidationsRequest(this);
        }
    }
}
