/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDistributionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDistributionsResponse.Builder, ListDistributionsResponse> {
    private final DistributionList distributionList;

    private ListDistributionsResponse(BuilderImpl builder) {
        this.distributionList = builder.distributionList;
    }

    /**
     * <p>
     * The <code>DistributionList</code> type.
     * </p>
     * 
     * @return The <code>DistributionList</code> type.
     */
    public DistributionList distributionList() {
        return distributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((distributionList() == null) ? 0 : distributionList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsResponse)) {
            return false;
        }
        ListDistributionsResponse other = (ListDistributionsResponse) obj;
        if (other.distributionList() == null ^ this.distributionList() == null) {
            return false;
        }
        if (other.distributionList() != null && !other.distributionList().equals(this.distributionList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (distributionList() != null) {
            sb.append("DistributionList: ").append(distributionList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionList":
            return Optional.of(clazz.cast(distributionList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListDistributionsResponse> {
        /**
         * <p>
         * The <code>DistributionList</code> type.
         * </p>
         * 
         * @param distributionList
         *        The <code>DistributionList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionList(DistributionList distributionList);
    }

    static final class BuilderImpl implements Builder {
        private DistributionList distributionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsResponse model) {
            distributionList(model.distributionList);
        }

        public final DistributionList.Builder getDistributionList() {
            return distributionList != null ? distributionList.toBuilder() : null;
        }

        @Override
        public final Builder distributionList(DistributionList distributionList) {
            this.distributionList = distributionList;
            return this;
        }

        public final void setDistributionList(DistributionList.BuilderImpl distributionList) {
            this.distributionList = distributionList != null ? distributionList.build() : null;
        }

        @Override
        public ListDistributionsResponse build() {
            return new ListDistributionsResponse(this);
        }
    }
}
