/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to list distributions that are associated with a specified AWS WAF web ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDistributionsByWebACLIdRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListDistributionsByWebACLIdRequest.Builder, ListDistributionsByWebACLIdRequest> {
    private final String marker;

    private final String maxItems;

    private final String webACLId;

    private ListDistributionsByWebACLIdRequest(BuilderImpl builder) {
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.webACLId = builder.webACLId;
    }

    /**
     * <p>
     * Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
     * <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code>
     * element. To get the next page of results, submit another request. For the value of <code>Marker</code>, specify
     * the value of <code>NextMarker</code> from the last response. (For the first request, omit <code>Marker</code>.)
     * </p>
     * 
     * @return Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
     *         <code>MaxItems</code> distributions that satisfy the request, the response includes a
     *         <code>NextMarker</code> element. To get the next page of results, submit another request. For the value
     *         of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response. (For the
     *         first request, omit <code>Marker</code>.)
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and
     * default values are both 100.
     * </p>
     * 
     * @return The maximum number of distributions that you want CloudFront to return in the response body. The maximum
     *         and default values are both 100.
     */
    public String maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The ID of the AWS WAF web ACL that you want to list the associated distributions. If you specify "null" for the
     * ID, the request returns a list of the distributions that aren't associated with a web ACL.
     * </p>
     * 
     * @return The ID of the AWS WAF web ACL that you want to list the associated distributions. If you specify "null"
     *         for the ID, the request returns a list of the distributions that aren't associated with a web ACL.
     */
    public String webACLId() {
        return webACLId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        hashCode = 31 * hashCode + ((webACLId() == null) ? 0 : webACLId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionsByWebACLIdRequest)) {
            return false;
        }
        ListDistributionsByWebACLIdRequest other = (ListDistributionsByWebACLIdRequest) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.webACLId() == null ^ this.webACLId() == null) {
            return false;
        }
        if (other.webACLId() != null && !other.webACLId().equals(this.webACLId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (webACLId() != null) {
            sb.append("WebACLId: ").append(webACLId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        case "WebACLId":
            return Optional.of(clazz.cast(webACLId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListDistributionsByWebACLIdRequest> {
        /**
         * <p>
         * Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more than
         * <code>MaxItems</code> distributions that satisfy the request, the response includes a <code>NextMarker</code>
         * element. To get the next page of results, submit another request. For the value of <code>Marker</code>,
         * specify the value of <code>NextMarker</code> from the last response. (For the first request, omit
         * <code>Marker</code>.)
         * </p>
         * 
         * @param marker
         *        Use <code>Marker</code> and <code>MaxItems</code> to control pagination of results. If you have more
         *        than <code>MaxItems</code> distributions that satisfy the request, the response includes a
         *        <code>NextMarker</code> element. To get the next page of results, submit another request. For the
         *        value of <code>Marker</code>, specify the value of <code>NextMarker</code> from the last response.
         *        (For the first request, omit <code>Marker</code>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of distributions that you want CloudFront to return in the response body. The maximum and
         * default values are both 100.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of distributions that you want CloudFront to return in the response body. The
         *        maximum and default values are both 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        /**
         * <p>
         * The ID of the AWS WAF web ACL that you want to list the associated distributions. If you specify "null" for
         * the ID, the request returns a list of the distributions that aren't associated with a web ACL.
         * </p>
         * 
         * @param webACLId
         *        The ID of the AWS WAF web ACL that you want to list the associated distributions. If you specify
         *        "null" for the ID, the request returns a list of the distributions that aren't associated with a web
         *        ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private String maxItems;

        private String webACLId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionsByWebACLIdRequest model) {
            marker(model.marker);
            maxItems(model.maxItems);
            webACLId(model.webACLId);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public ListDistributionsByWebACLIdRequest build() {
            return new ListDistributionsByWebACLIdRequest(this);
        }
    }
}
