/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned result of the corresponding request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListCloudFrontOriginAccessIdentitiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListCloudFrontOriginAccessIdentitiesResponse.Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
    private final CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

    private ListCloudFrontOriginAccessIdentitiesResponse(BuilderImpl builder) {
        this.cloudFrontOriginAccessIdentityList = builder.cloudFrontOriginAccessIdentityList;
    }

    /**
     * <p>
     * The <code>CloudFrontOriginAccessIdentityList</code> type.
     * </p>
     * 
     * @return The <code>CloudFrontOriginAccessIdentityList</code> type.
     */
    public CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList() {
        return cloudFrontOriginAccessIdentityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((cloudFrontOriginAccessIdentityList() == null) ? 0 : cloudFrontOriginAccessIdentityList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCloudFrontOriginAccessIdentitiesResponse)) {
            return false;
        }
        ListCloudFrontOriginAccessIdentitiesResponse other = (ListCloudFrontOriginAccessIdentitiesResponse) obj;
        if (other.cloudFrontOriginAccessIdentityList() == null ^ this.cloudFrontOriginAccessIdentityList() == null) {
            return false;
        }
        if (other.cloudFrontOriginAccessIdentityList() != null
                && !other.cloudFrontOriginAccessIdentityList().equals(this.cloudFrontOriginAccessIdentityList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (cloudFrontOriginAccessIdentityList() != null) {
            sb.append("CloudFrontOriginAccessIdentityList: ").append(cloudFrontOriginAccessIdentityList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFrontOriginAccessIdentityList":
            return Optional.of(clazz.cast(cloudFrontOriginAccessIdentityList()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ListCloudFrontOriginAccessIdentitiesResponse> {
        /**
         * <p>
         * The <code>CloudFrontOriginAccessIdentityList</code> type.
         * </p>
         * 
         * @param cloudFrontOriginAccessIdentityList
         *        The <code>CloudFrontOriginAccessIdentityList</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFrontOriginAccessIdentityList(CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList);
    }

    static final class BuilderImpl implements Builder {
        private CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCloudFrontOriginAccessIdentitiesResponse model) {
            cloudFrontOriginAccessIdentityList(model.cloudFrontOriginAccessIdentityList);
        }

        public final CloudFrontOriginAccessIdentityList.Builder getCloudFrontOriginAccessIdentityList() {
            return cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityList(
                CloudFrontOriginAccessIdentityList.BuilderImpl cloudFrontOriginAccessIdentityList) {
            this.cloudFrontOriginAccessIdentityList = cloudFrontOriginAccessIdentityList != null ? cloudFrontOriginAccessIdentityList
                    .build() : null;
        }

        @Override
        public ListCloudFrontOriginAccessIdentitiesResponse build() {
            return new ListCloudFrontOriginAccessIdentitiesResponse(this);
        }
    }
}
